/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.configuration;

import io.camunda.zeebe.broker.system.configuration.NetworkCfg;
import java.net.InetSocketAddress;
import java.util.Optional;

public class SocketBindingCfg {
    private final int defaultPort;
    private String host;
    private Integer port;
    private String advertisedHost;
    private Integer advertisedPort;

    private SocketBindingCfg(int defaultPort) {
        this.defaultPort = defaultPort;
    }

    public InetSocketAddress getAddress() {
        return new InetSocketAddress(this.host, (int)this.port);
    }

    public InetSocketAddress getAdvertisedAddress() {
        return InetSocketAddress.createUnresolved(this.advertisedHost, this.advertisedPort);
    }

    public void applyDefaults(NetworkCfg networkCfg) {
        this.advertisedHost = Optional.ofNullable(this.advertisedHost).orElseGet(() -> Optional.ofNullable(this.host).orElseGet(networkCfg::getAdvertisedHost));
        this.host = Optional.ofNullable(this.host).orElse(networkCfg.getHost());
        this.port = Optional.ofNullable(this.port).orElse(this.defaultPort) + networkCfg.getPortOffset() * 10;
        this.advertisedPort = Optional.ofNullable(this.advertisedPort).map(p -> p + networkCfg.getPortOffset() * 10).orElse(this.port);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getAdvertisedHost() {
        return this.advertisedHost;
    }

    public void setAdvertisedHost(String advertisedHost) {
        this.advertisedHost = advertisedHost;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getAdvertisedPort() {
        return this.advertisedPort;
    }

    public void setAdvertisedPort(int advertisedPort) {
        this.advertisedPort = advertisedPort;
    }

    public String toString() {
        return "SocketBindingCfg{host='" + this.host + "', port=" + this.port + ", advertisedHost=" + this.advertisedHost + ", advertisedPort=" + this.advertisedPort + "}";
    }

    public static class InternalApiCfg
    extends SocketBindingCfg {
        public InternalApiCfg() {
            super(26502);
        }
    }

    public static class CommandApiCfg
    extends SocketBindingCfg {
        public CommandApiCfg() {
            super(26501);
        }

        @Override
        public String toString() {
            return "CommandApiCfg{host='" + this.getHost() + "', port=" + this.getPort() + ", advertisedHost=" + this.getAdvertisedHost() + ", advertisedPort=" + this.getAdvertisedPort() + "}";
        }
    }
}

