/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.configuration.backpressure;

import io.camunda.zeebe.broker.system.configuration.ConfigurationEntry;
import io.camunda.zeebe.broker.system.configuration.backpressure.AIMDCfg;
import io.camunda.zeebe.broker.system.configuration.backpressure.FixedCfg;
import io.camunda.zeebe.broker.system.configuration.backpressure.Gradient2Cfg;
import io.camunda.zeebe.broker.system.configuration.backpressure.GradientCfg;
import io.camunda.zeebe.broker.system.configuration.backpressure.VegasCfg;

public final class BackpressureCfg
implements ConfigurationEntry {
    private boolean enabled = true;
    private boolean useWindowed = true;
    private LimitAlgorithm algorithm = LimitAlgorithm.AIMD;
    private final AIMDCfg aimd = new AIMDCfg();
    private final FixedCfg fixed = new FixedCfg();
    private final VegasCfg vegas = new VegasCfg();
    private final GradientCfg gradient = new GradientCfg();
    private final Gradient2Cfg gradient2 = new Gradient2Cfg();

    public boolean isEnabled() {
        return this.enabled;
    }

    public BackpressureCfg setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public boolean useWindowed() {
        return this.useWindowed;
    }

    public void setUseWindowed(boolean useWindowed) {
        this.useWindowed = useWindowed;
    }

    public LimitAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = LimitAlgorithm.valueOf(algorithm.toUpperCase());
    }

    public AIMDCfg getAimd() {
        return this.aimd;
    }

    public FixedCfg getFixed() {
        return this.fixed;
    }

    public VegasCfg getVegas() {
        return this.vegas;
    }

    public GradientCfg getGradient() {
        return this.gradient;
    }

    public Gradient2Cfg getGradient2() {
        return this.gradient2;
    }

    public String toString() {
        return "BackpressureCfg{enabled=" + this.enabled + ", useWindowed=" + this.useWindowed + ", algorithm='" + this.algorithm + "', aimd=" + this.aimd + ", fixed=" + this.fixed + ", vegas=" + this.vegas + ", gradient=" + this.gradient + ", gradient2=" + this.gradient2 + "}";
    }

    public static enum LimitAlgorithm {
        VEGAS,
        GRADIENT,
        GRADIENT2,
        FIXED,
        AIMD;

    }
}

