/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.configuration.backup;

import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.configuration.ConfigurationEntry;
import io.camunda.zeebe.broker.system.configuration.backup.GcsBackupStoreConfig;
import io.camunda.zeebe.broker.system.configuration.backup.S3BackupStoreConfig;

public class BackupStoreCfg
implements ConfigurationEntry {
    private BackupStoreType store = BackupStoreType.NONE;
    private S3BackupStoreConfig s3 = new S3BackupStoreConfig();
    private GcsBackupStoreConfig gcs = new GcsBackupStoreConfig();

    public S3BackupStoreConfig getS3() {
        return this.s3;
    }

    public void setS3(S3BackupStoreConfig s3) {
        this.s3 = s3;
    }

    public GcsBackupStoreConfig getGcs() {
        return this.gcs;
    }

    public void setGcs(GcsBackupStoreConfig gcs) {
        this.gcs = gcs;
    }

    public BackupStoreType getStore() {
        return this.store;
    }

    public void setStore(BackupStoreType store) {
        this.store = store;
    }

    @Override
    public void init(BrokerCfg globalConfig, String brokerBase) {
        this.s3.init(globalConfig, brokerBase);
        this.gcs.init(globalConfig, brokerBase);
    }

    public String toString() {
        return switch (this.store) {
            default -> throw new IncompatibleClassChangeError();
            case BackupStoreType.NONE -> "BackupStoreCfg{store=" + this.store + "}";
            case BackupStoreType.S3 -> "BackupStoreCfg{store=" + this.store + ", s3=" + this.s3 + "}";
            case BackupStoreType.GCS -> "BackupStoreCfg{store=" + this.store + ", gcs=" + this.gcs + "}";
        };
    }

    public static enum BackupStoreType {
        S3,
        GCS,
        NONE;

    }
}

