/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions;

import io.camunda.zeebe.broker.system.partitions.PartitionTransitionContext;
import io.camunda.zeebe.broker.system.partitions.impl.RecoverablePartitionTransitionException;
import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.util.health.HealthIssue;

public interface PartitionTransition {
    public ActorFuture<Void> toFollower(long var1);

    public ActorFuture<Void> toLeader(long var1);

    public ActorFuture<Void> toInactive(long var1);

    public void setConcurrencyControl(ConcurrencyControl var1);

    public void updateTransitionContext(PartitionTransitionContext var1);

    public HealthIssue getHealthIssue();

    public static final class FailedPartitionTransitionPreparation
    extends RuntimeException {
        public FailedPartitionTransitionPreparation(Throwable cause) {
            super("Preparing for partition transition failed", cause);
        }
    }

    public static final class CancelledPartitionTransition
    extends RecoverablePartitionTransitionException {
        public CancelledPartitionTransition() {
            super("Partition transition was cancelled");
        }
    }
}

