/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions;

import io.camunda.zeebe.broker.system.partitions.PartitionTransition;
import io.camunda.zeebe.util.health.FailureListener;
import io.camunda.zeebe.util.health.HealthIssue;
import io.camunda.zeebe.util.health.HealthMonitorable;
import io.camunda.zeebe.util.health.HealthReport;
import io.camunda.zeebe.util.health.HealthStatus;
import java.util.HashSet;
import java.util.Set;

class ZeebePartitionHealth
implements HealthMonitorable {
    private final String name;
    private final Set<FailureListener> failureListeners = new HashSet<FailureListener>();
    private HealthReport healthReport;
    private final PartitionTransition partitionTransition;
    private boolean servicesInstalled;
    private boolean diskSpaceAvailable = true;

    public ZeebePartitionHealth(int partitionId, PartitionTransition partitionTransition) {
        this.name = "ZeebePartition-" + partitionId;
        this.partitionTransition = partitionTransition;
    }

    private void updateHealthStatus() {
        HealthReport previousStatus = this.healthReport;
        if (this.healthReport != null && previousStatus.getStatus() == HealthStatus.DEAD) {
            return;
        }
        HealthIssue partitionTransitionHealthIssue = this.partitionTransition.getHealthIssue();
        this.healthReport = !this.diskSpaceAvailable ? HealthReport.unhealthy((HealthMonitorable)this).withMessage("Not enough disk space available") : (partitionTransitionHealthIssue != null ? HealthReport.unhealthy((HealthMonitorable)this).withIssue(partitionTransitionHealthIssue) : (!this.servicesInstalled ? HealthReport.unhealthy((HealthMonitorable)this).withMessage("Services not installed") : HealthReport.healthy((HealthMonitorable)this)));
        if (previousStatus != this.healthReport) {
            switch (this.healthReport.getStatus()) {
                case HEALTHY: {
                    this.failureListeners.forEach(FailureListener::onRecovered);
                    break;
                }
                case UNHEALTHY: {
                    this.failureListeners.forEach(l -> l.onFailure(this.healthReport));
                    break;
                }
                case DEAD: {
                    this.failureListeners.forEach(l -> l.onUnrecoverableFailure(this.healthReport));
                    break;
                }
            }
        }
    }

    void setServicesInstalled(boolean servicesInstalled) {
        this.servicesInstalled = servicesInstalled;
        this.updateHealthStatus();
    }

    void setDiskSpaceAvailable(boolean diskSpaceAvailable) {
        this.diskSpaceAvailable = diskSpaceAvailable;
        this.updateHealthStatus();
    }

    void onUnrecoverableFailure(Throwable error) {
        this.healthReport = HealthReport.dead((HealthMonitorable)this).withIssue(error);
    }

    public String getName() {
        return this.name;
    }

    public HealthReport getHealthReport() {
        this.updateHealthStatus();
        return this.healthReport;
    }

    public void addFailureListener(FailureListener failureListener) {
        this.failureListeners.add(failureListener);
    }

    public void removeFailureListener(FailureListener failureListener) {
        this.failureListeners.remove(failureListener);
    }
}

