/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.transport.backpressure;

import com.netflix.concurrency.limits.Limit;
import com.netflix.concurrency.limits.limit.FixedLimit;
import com.netflix.concurrency.limits.limit.Gradient2Limit;
import com.netflix.concurrency.limits.limit.GradientLimit;
import com.netflix.concurrency.limits.limit.VegasLimit;
import com.netflix.concurrency.limits.limit.WindowedLimit;
import io.camunda.zeebe.broker.Broker;
import io.camunda.zeebe.broker.system.configuration.backpressure.AIMDCfg;
import io.camunda.zeebe.broker.system.configuration.backpressure.BackpressureCfg;
import io.camunda.zeebe.broker.system.configuration.backpressure.FixedCfg;
import io.camunda.zeebe.broker.system.configuration.backpressure.Gradient2Cfg;
import io.camunda.zeebe.broker.system.configuration.backpressure.GradientCfg;
import io.camunda.zeebe.broker.system.configuration.backpressure.VegasCfg;
import io.camunda.zeebe.broker.transport.backpressure.CommandRateLimiter;
import io.camunda.zeebe.broker.transport.backpressure.NoopRequestLimiter;
import io.camunda.zeebe.broker.transport.backpressure.RequestLimiter;
import io.camunda.zeebe.broker.transport.backpressure.StabilizingAIMDLimit;
import io.camunda.zeebe.protocol.record.intent.Intent;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;

public final class PartitionAwareRequestLimiter {
    private final Map<Integer, RequestLimiter<Intent>> partitionLimiters = new ConcurrentHashMap<Integer, RequestLimiter<Intent>>();
    private final Function<Integer, RequestLimiter<Intent>> limiterSupplier;

    private PartitionAwareRequestLimiter() {
        this.limiterSupplier = i -> new NoopRequestLimiter();
    }

    private PartitionAwareRequestLimiter(Supplier<Limit> limitSupplier) {
        this.limiterSupplier = i -> ((CommandRateLimiter.CommandRateLimiterBuilder)CommandRateLimiter.builder().limit((Limit)limitSupplier.get())).build((int)i);
    }

    public static PartitionAwareRequestLimiter newNoopLimiter() {
        return new PartitionAwareRequestLimiter();
    }

    public static PartitionAwareRequestLimiter newLimiter(BackpressureCfg backpressureCfg) {
        BackpressureCfg.LimitAlgorithm algorithm = backpressureCfg.getAlgorithm();
        Supplier<Limit> limit = switch (algorithm) {
            case BackpressureCfg.LimitAlgorithm.AIMD -> {
                AIMDCfg aimdCfg = backpressureCfg.getAimd();
                yield () -> PartitionAwareRequestLimiter.getAIMD(aimdCfg);
            }
            case BackpressureCfg.LimitAlgorithm.FIXED -> {
                FixedCfg fixedCfg = backpressureCfg.getFixed();
                yield () -> FixedLimit.of((int)fixedCfg.getLimit());
            }
            case BackpressureCfg.LimitAlgorithm.GRADIENT -> {
                GradientCfg gradientCfg = backpressureCfg.getGradient();
                yield () -> PartitionAwareRequestLimiter.getGradientLimit(gradientCfg);
            }
            case BackpressureCfg.LimitAlgorithm.GRADIENT2 -> {
                Gradient2Cfg gradient2Cfg = backpressureCfg.getGradient2();
                yield () -> PartitionAwareRequestLimiter.getGradient2Limit(gradient2Cfg);
            }
            case BackpressureCfg.LimitAlgorithm.VEGAS -> {
                VegasCfg vegasCfg = backpressureCfg.getVegas();
                yield () -> PartitionAwareRequestLimiter.getVegasLimit(vegasCfg);
            }
            default -> {
                Broker.LOG.warn("Found unknown backpressure algorithm {}. Using {} instead", (Object)algorithm, (Object)BackpressureCfg.LimitAlgorithm.VEGAS);
                yield () -> PartitionAwareRequestLimiter.getVegasLimit(backpressureCfg.getVegas());
            }
        };
        if (backpressureCfg.useWindowed()) {
            return new PartitionAwareRequestLimiter(() -> WindowedLimit.newBuilder().build((Limit)limit.get()));
        }
        return new PartitionAwareRequestLimiter(limit);
    }

    private static VegasLimit getVegasLimit(VegasCfg vegasCfg) {
        return VegasLimit.newBuilder().alpha(vegasCfg.getAlpha()).beta(vegasCfg.getBeta()).initialLimit(vegasCfg.getInitialLimit()).build();
    }

    private static Gradient2Limit getGradient2Limit(Gradient2Cfg gradient2Cfg) {
        return Gradient2Limit.newBuilder().rttTolerance(gradient2Cfg.getRttTolerance()).initialLimit(gradient2Cfg.getInitialLimit()).minLimit(gradient2Cfg.getMinLimit()).longWindow(gradient2Cfg.getLongWindow()).build();
    }

    private static GradientLimit getGradientLimit(GradientCfg gradientCfg) {
        return GradientLimit.newBuilder().minLimit(gradientCfg.getMinLimit()).initialLimit(gradientCfg.getInitialLimit()).rttTolerance(gradientCfg.getRttTolerance()).build();
    }

    private static StabilizingAIMDLimit getAIMD(AIMDCfg aimdCfg) {
        return StabilizingAIMDLimit.newBuilder().initialLimit(aimdCfg.getInitialLimit()).minLimit(aimdCfg.getMinLimit()).maxLimit(aimdCfg.getMaxLimit()).expectedRTT(aimdCfg.getRequestTimeout().toMillis(), TimeUnit.MILLISECONDS).backoffRatio(aimdCfg.getBackoffRatio()).build();
    }

    public boolean tryAcquire(int partitionId, int streamId, long requestId, Intent context) {
        RequestLimiter<Intent> limiter = this.getLimiter(partitionId);
        return limiter.tryAcquire(streamId, requestId, context);
    }

    public void onResponse(int partitionId, int streamId, long requestId) {
        RequestLimiter<Intent> limiter = this.partitionLimiters.get(partitionId);
        if (limiter != null) {
            limiter.onResponse(streamId, requestId);
        }
    }

    public void addPartition(int partitionId) {
        this.getOrCreateLimiter(partitionId);
    }

    public void removePartition(int partitionId) {
        this.partitionLimiters.remove(partitionId);
    }

    public RequestLimiter<Intent> getLimiter(int partitionId) {
        return this.getOrCreateLimiter(partitionId);
    }

    private RequestLimiter<Intent> getOrCreateLimiter(int partitionId) {
        return this.partitionLimiters.computeIfAbsent(partitionId, this.limiterSupplier);
    }
}

