/*
 * Decompiled with CFR 0.152.
 */
package autovalue.shaded.com.google.escapevelocity;

import autovalue.shaded.com.google.common.collect.ImmutableList;
import autovalue.shaded.com.google.escapevelocity.EvaluationContext;
import autovalue.shaded.com.google.escapevelocity.EvaluationException;

abstract class Node {
    final String resourceName;
    final int lineNumber;

    Node(String resourceName, int lineNumber) {
        this.resourceName = resourceName;
        this.lineNumber = lineNumber;
    }

    abstract Object evaluate(EvaluationContext var1);

    private String where() {
        String where = "In expression on line " + this.lineNumber;
        if (this.resourceName != null) {
            where = where + " of " + this.resourceName;
        }
        return where;
    }

    EvaluationException evaluationException(String message) {
        return new EvaluationException(this.where() + ": " + message);
    }

    EvaluationException evaluationException(Throwable cause) {
        return new EvaluationException(this.where() + ": " + cause, cause);
    }

    static Node emptyNode(String resourceName, int lineNumber) {
        return new Cons(resourceName, lineNumber, ImmutableList.of());
    }

    static Node cons(String resourceName, int lineNumber, ImmutableList<Node> nodes) {
        return new Cons(resourceName, lineNumber, nodes);
    }

    private static final class Cons
    extends Node {
        private final ImmutableList<Node> nodes;

        Cons(String resourceName, int lineNumber, ImmutableList<Node> nodes) {
            super(resourceName, lineNumber);
            this.nodes = nodes;
        }

        @Override
        Object evaluate(EvaluationContext context) {
            StringBuilder sb = new StringBuilder();
            for (Node node : this.nodes) {
                sb.append(node.evaluate(context));
            }
            return sb.toString();
        }
    }
}

