/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.admin.backup;

import io.camunda.zeebe.gateway.admin.backup.BackupResponse;
import io.camunda.zeebe.gateway.cmd.UnsupportedBrokerResponseException;
import io.camunda.zeebe.gateway.impl.broker.request.BrokerRequest;
import io.camunda.zeebe.gateway.impl.broker.response.BrokerRejection;
import io.camunda.zeebe.gateway.impl.broker.response.BrokerRejectionResponse;
import io.camunda.zeebe.gateway.impl.broker.response.BrokerResponse;
import io.camunda.zeebe.protocol.impl.encoding.BackupRequest;
import io.camunda.zeebe.protocol.impl.encoding.ExecuteCommandResponse;
import io.camunda.zeebe.protocol.impl.record.value.management.CheckpointRecord;
import io.camunda.zeebe.protocol.management.BackupRequestType;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.management.CheckpointIntent;
import io.camunda.zeebe.transport.RequestType;
import io.camunda.zeebe.util.buffer.BufferWriter;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public final class BrokerBackupRequest
extends BrokerRequest<BackupResponse> {
    final BackupRequest request = new BackupRequest();
    final ExecuteCommandResponse response = new ExecuteCommandResponse();

    public BrokerBackupRequest() {
        super(0, 21);
        this.request.setType(BackupRequestType.TAKE_BACKUP);
    }

    public int getPartitionId() {
        return this.request.getPartitionId();
    }

    @Override
    public void setPartitionId(int partitionId) {
        this.request.setPartitionId(partitionId);
    }

    @Override
    public boolean addressesSpecificPartition() {
        return true;
    }

    @Override
    public boolean requiresPartitionId() {
        return true;
    }

    @Override
    public BufferWriter getRequestWriter() {
        return null;
    }

    @Override
    protected void setSerializedValue(DirectBuffer buffer) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void wrapResponse(DirectBuffer buffer) {
        this.response.wrap(buffer, 0, buffer.capacity());
    }

    @Override
    protected BrokerResponse<BackupResponse> readResponse() {
        if (this.response.getRecordType() == RecordType.COMMAND_REJECTION) {
            BrokerRejection brokerRejection = new BrokerRejection((Intent)CheckpointIntent.CREATE, this.request.getBackupId(), this.response.getRejectionType(), this.response.getRejectionReason());
            return new BrokerRejectionResponse<BackupResponse>(brokerRejection);
        }
        if (this.response.getValueType() == ValueType.CHECKPOINT) {
            BackupResponse responseDto = this.toResponseDto(this.response.getValue());
            return new BrokerResponse<BackupResponse>(responseDto, this.response.getPartitionId(), this.response.getKey());
        }
        throw new UnsupportedBrokerResponseException(ValueType.CHECKPOINT.name(), this.response.getValueType().name());
    }

    @Override
    protected BackupResponse toResponseDto(DirectBuffer buffer) {
        CheckpointRecord responseDto = new CheckpointRecord();
        responseDto.wrap(buffer);
        return new BackupResponse(this.response.getIntent() == CheckpointIntent.CREATED, responseDto.getCheckpointId());
    }

    @Override
    public String getType() {
        return "Backup#take";
    }

    public RequestType getRequestType() {
        return RequestType.BACKUP;
    }

    public long getBackupId() {
        return this.request.getBackupId();
    }

    public void setBackupId(long backupId) {
        this.request.setBackupId(backupId);
    }

    public int getLength() {
        return this.request.getLength();
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        this.request.write(buffer, offset);
    }
}

