/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.admin.backup;

import io.camunda.zeebe.protocol.impl.encoding.BackupStatusResponse;
import io.camunda.zeebe.protocol.management.BackupStatusCode;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;

public record PartitionBackupStatus(int partitionId, BackupStatusCode status, Optional<String> failureReason, Optional<String> createdAt, Optional<String> lastUpdatedAt, Optional<String> snapshotId, OptionalLong checkpointPosition, OptionalInt brokerId, Optional<String> brokerVersion) {
    static PartitionBackupStatus from(BackupStatusResponse response) {
        BackupStatusCode status = response.getStatus();
        return switch (status) {
            case BackupStatusCode.FAILED -> PartitionBackupStatus.failedStatus(response);
            case BackupStatusCode.DOES_NOT_EXIST -> PartitionBackupStatus.notExistingStatus(response.getPartitionId());
            case BackupStatusCode.IN_PROGRESS, BackupStatusCode.COMPLETED -> PartitionBackupStatus.validStatus(response);
            default -> throw new IllegalArgumentException("Unknown backup status %s".formatted(status));
        };
    }

    private static PartitionBackupStatus validStatus(BackupStatusResponse response) {
        return new PartitionBackupStatus(response.getPartitionId(), response.getStatus(), Optional.empty(), Optional.ofNullable(response.getCreatedAt()), Optional.ofNullable(response.getLastUpdated()), Optional.ofNullable(response.getSnapshotId()), response.hasCheckpointPosition() ? OptionalLong.of(response.getCheckpointPosition()) : OptionalLong.empty(), response.hasBrokerId() ? OptionalInt.of(response.getBrokerId()) : OptionalInt.empty(), Optional.ofNullable(response.getBrokerVersion()));
    }

    static PartitionBackupStatus notExistingStatus(int partitionId) {
        return new PartitionBackupStatus(partitionId, BackupStatusCode.DOES_NOT_EXIST, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), OptionalLong.empty(), OptionalInt.empty(), Optional.empty());
    }

    private static PartitionBackupStatus failedStatus(BackupStatusResponse response) {
        return new PartitionBackupStatus(response.getPartitionId(), BackupStatusCode.FAILED, Optional.of(response.getFailureReason()), Optional.ofNullable(response.getCreatedAt()), Optional.ofNullable(response.getLastUpdated()), Optional.ofNullable(response.getSnapshotId()), OptionalLong.empty(), OptionalInt.empty(), Optional.empty());
    }
}

