/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.impl.broker;

import io.atomix.cluster.ClusterMembershipEvent;
import io.atomix.cluster.ClusterMembershipService;
import io.atomix.cluster.messaging.ClusterEventService;
import io.atomix.cluster.messaging.MessagingService;
import io.atomix.cluster.messaging.Subscription;
import io.atomix.utils.event.EventListener;
import io.camunda.zeebe.gateway.Loggers;
import io.camunda.zeebe.gateway.impl.broker.BrokerClient;
import io.camunda.zeebe.gateway.impl.broker.BrokerRequestManager;
import io.camunda.zeebe.gateway.impl.broker.BrokerResponseConsumer;
import io.camunda.zeebe.gateway.impl.broker.RoundRobinDispatchStrategy;
import io.camunda.zeebe.gateway.impl.broker.cluster.BrokerTopologyManager;
import io.camunda.zeebe.gateway.impl.broker.cluster.BrokerTopologyManagerImpl;
import io.camunda.zeebe.gateway.impl.broker.request.BrokerRequest;
import io.camunda.zeebe.gateway.impl.broker.response.BrokerResponse;
import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.ActorSchedulingService;
import io.camunda.zeebe.transport.ClientTransport;
import io.camunda.zeebe.transport.impl.AtomixClientTransportAdapter;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;

public final class BrokerClientImpl
implements BrokerClient {
    public static final Logger LOG = Loggers.GATEWAY_LOGGER;
    private final BrokerTopologyManagerImpl topologyManager;
    private final BrokerRequestManager requestManager;
    private boolean isClosed;
    private Subscription jobAvailableSubscription;
    private final ClusterEventService eventService;
    private final ActorSchedulingService schedulingService;
    private final AtomixClientTransportAdapter atomixTransportAdapter;

    public BrokerClientImpl(Duration requestTimeout, MessagingService messagingService, ClusterMembershipService membershipService, ClusterEventService eventService, ActorSchedulingService schedulingService) {
        this.eventService = eventService;
        this.schedulingService = schedulingService;
        this.topologyManager = new BrokerTopologyManagerImpl(() -> ((ClusterMembershipService)membershipService).getMembers());
        membershipService.addListener((EventListener)this.topologyManager);
        membershipService.getMembers().forEach(member -> this.topologyManager.event(new ClusterMembershipEvent(ClusterMembershipEvent.Type.MEMBER_ADDED, member)));
        this.atomixTransportAdapter = new AtomixClientTransportAdapter(messagingService);
        this.requestManager = new BrokerRequestManager((ClientTransport)this.atomixTransportAdapter, this.topologyManager, new RoundRobinDispatchStrategy(this.topologyManager), requestTimeout);
    }

    @Override
    public void start() {
        this.schedulingService.submitActor((Actor)this.topologyManager);
        this.schedulingService.submitActor((Actor)this.atomixTransportAdapter);
        this.schedulingService.submitActor((Actor)this.requestManager);
    }

    @Override
    public void close() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        LOG.debug("Closing gateway broker client ...");
        this.doAndLogException(() -> ((BrokerTopologyManagerImpl)this.topologyManager).close());
        LOG.debug("topology manager closed");
        if (this.jobAvailableSubscription != null) {
            this.jobAvailableSubscription.close();
        }
        LOG.debug("Gateway broker client closed.");
    }

    @Override
    public <T> CompletableFuture<BrokerResponse<T>> sendRequest(BrokerRequest<T> request) {
        return this.requestManager.sendRequest(request);
    }

    @Override
    public <T> CompletableFuture<BrokerResponse<T>> sendRequest(BrokerRequest<T> request, Duration requestTimeout) {
        return this.requestManager.sendRequest(request, requestTimeout);
    }

    @Override
    public <T> CompletableFuture<BrokerResponse<T>> sendRequestWithRetry(BrokerRequest<T> request) {
        return this.requestManager.sendRequestWithRetry(request);
    }

    @Override
    public <T> CompletableFuture<BrokerResponse<T>> sendRequestWithRetry(BrokerRequest<T> request, Duration requestTimeout) {
        return this.requestManager.sendRequestWithRetry(request, requestTimeout);
    }

    @Override
    public <T> void sendRequestWithRetry(BrokerRequest<T> request, BrokerResponseConsumer<T> responseConsumer, Consumer<Throwable> throwableConsumer) {
        this.requestManager.sendRequestWithRetry(request).whenComplete((response, error) -> {
            if (error == null) {
                responseConsumer.accept(response.getKey(), response.getResponse());
            } else {
                throwableConsumer.accept((Throwable)error);
            }
        });
    }

    @Override
    public BrokerTopologyManager getTopologyManager() {
        return this.topologyManager;
    }

    @Override
    public void subscribeJobAvailableNotification(String topic, Consumer<String> handler) {
        this.jobAvailableSubscription = (Subscription)this.eventService.subscribe(topic, msg -> {
            handler.accept((String)msg);
            return CompletableFuture.completedFuture(null);
        }).join();
    }

    private void doAndLogException(Runnable r) {
        try {
            r.run();
        }
        catch (Exception e) {
            LOG.error("Exception when closing client. Ignoring", (Throwable)e);
        }
    }
}

