/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.impl.broker.request;

import io.camunda.zeebe.gateway.RequestMapper;
import io.camunda.zeebe.gateway.impl.broker.request.BrokerExecuteCommand;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceModificationActivateInstruction;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceModificationRecord;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceModificationTerminateInstruction;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceModificationVariableInstruction;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceModificationIntent;
import java.util.List;
import org.agrona.DirectBuffer;

public final class BrokerModifyProcessInstanceRequest
extends BrokerExecuteCommand<ProcessInstanceModificationRecord> {
    private final ProcessInstanceModificationRecord requestDto = new ProcessInstanceModificationRecord();

    public BrokerModifyProcessInstanceRequest() {
        super(ValueType.PROCESS_INSTANCE_MODIFICATION, (Intent)ProcessInstanceModificationIntent.MODIFY);
    }

    public BrokerModifyProcessInstanceRequest setProcessInstanceKey(long processInstanceKey) {
        this.requestDto.setProcessInstanceKey(processInstanceKey);
        this.request.setKey(processInstanceKey);
        return this;
    }

    public BrokerModifyProcessInstanceRequest addActivateInstructions(List<GatewayOuterClass.ModifyProcessInstanceRequest.ActivateInstruction> activateInstructions) {
        activateInstructions.stream().map(activateInstructionReq -> {
            ProcessInstanceModificationActivateInstruction activateInstructionResp = new ProcessInstanceModificationActivateInstruction();
            activateInstructionResp.setElementId(activateInstructionReq.getElementId()).setAncestorScopeKey(activateInstructionReq.getAncestorElementInstanceKey());
            activateInstructionReq.getVariableInstructionsList().stream().map(this::mapVariableInstruction).forEach(arg_0 -> ((ProcessInstanceModificationActivateInstruction)activateInstructionResp).addVariableInstruction(arg_0));
            return activateInstructionResp;
        }).forEach(arg_0 -> ((ProcessInstanceModificationRecord)this.requestDto).addActivateInstruction(arg_0));
        return this;
    }

    private ProcessInstanceModificationVariableInstruction mapVariableInstruction(GatewayOuterClass.ModifyProcessInstanceRequest.VariableInstruction instruction) {
        return new ProcessInstanceModificationVariableInstruction().setElementId(instruction.getScopeId()).setVariables(RequestMapper.ensureJsonSet(instruction.getVariables()));
    }

    public BrokerModifyProcessInstanceRequest addTerminateInstructions(List<GatewayOuterClass.ModifyProcessInstanceRequest.TerminateInstruction> terminateInstructions) {
        terminateInstructions.stream().map(terminateInstruction -> new ProcessInstanceModificationTerminateInstruction().setElementInstanceKey(terminateInstruction.getElementInstanceKey())).forEach(arg_0 -> ((ProcessInstanceModificationRecord)this.requestDto).addTerminateInstruction(arg_0));
        return this;
    }

    public ProcessInstanceModificationRecord getRequestWriter() {
        return this.requestDto;
    }

    @Override
    protected ProcessInstanceModificationRecord toResponseDto(DirectBuffer buffer) {
        ProcessInstanceModificationRecord responseDto = new ProcessInstanceModificationRecord();
        responseDto.wrap(buffer);
        return responseDto;
    }
}

