/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.impl.configuration;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.camunda.zeebe.gateway.impl.configuration.ClusterCfg;
import io.camunda.zeebe.gateway.impl.configuration.InterceptorCfg;
import io.camunda.zeebe.gateway.impl.configuration.LongPollingCfg;
import io.camunda.zeebe.gateway.impl.configuration.NetworkCfg;
import io.camunda.zeebe.gateway.impl.configuration.SecurityCfg;
import io.camunda.zeebe.gateway.impl.configuration.ThreadsCfg;
import io.camunda.zeebe.util.ObjectWriterFactory;
import io.camunda.zeebe.util.exception.UncheckedExecutionException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="zeebe.gateway")
public class GatewayCfg {
    private NetworkCfg network = new NetworkCfg();
    private ClusterCfg cluster = new ClusterCfg();
    private ThreadsCfg threads = new ThreadsCfg();
    private SecurityCfg security = new SecurityCfg();
    private LongPollingCfg longPolling = new LongPollingCfg();
    private List<InterceptorCfg> interceptors = new ArrayList<InterceptorCfg>();
    private boolean initialized = false;

    public void init() {
        this.init("0.0.0.0");
    }

    public void init(String defaultHost) {
        this.network.init(defaultHost);
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public NetworkCfg getNetwork() {
        return this.network;
    }

    public GatewayCfg setNetwork(NetworkCfg network) {
        this.network = network;
        return this;
    }

    public ClusterCfg getCluster() {
        return this.cluster;
    }

    public GatewayCfg setCluster(ClusterCfg cluster) {
        this.cluster = cluster;
        return this;
    }

    public ThreadsCfg getThreads() {
        return this.threads;
    }

    public GatewayCfg setThreads(ThreadsCfg threads) {
        this.threads = threads;
        return this;
    }

    public SecurityCfg getSecurity() {
        return this.security;
    }

    public GatewayCfg setSecurity(SecurityCfg security) {
        this.security = security;
        return this;
    }

    public LongPollingCfg getLongPolling() {
        return this.longPolling;
    }

    public GatewayCfg setLongPolling(LongPollingCfg longPolling) {
        this.longPolling = longPolling;
        return this;
    }

    public List<InterceptorCfg> getInterceptors() {
        return this.interceptors;
    }

    public void setInterceptors(List<InterceptorCfg> interceptors) {
        this.interceptors = interceptors;
    }

    public int hashCode() {
        return Objects.hash(this.network, this.cluster, this.threads, this.security, this.longPolling, this.interceptors);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GatewayCfg that = (GatewayCfg)o;
        return Objects.equals(this.network, that.network) && Objects.equals(this.cluster, that.cluster) && Objects.equals(this.threads, that.threads) && Objects.equals(this.security, that.security) && Objects.equals(this.longPolling, that.longPolling) && Objects.equals(this.interceptors, that.interceptors);
    }

    public String toString() {
        return "GatewayCfg{networkCfg=" + this.network + ", clusterCfg=" + this.cluster + ", threadsCfg=" + this.threads + ", securityCfg=" + this.security + ", longPollingCfg=" + this.longPolling + ", interceptors=" + this.interceptors + "}";
    }

    public String toJson() {
        try {
            return ObjectWriterFactory.getDefaultJsonObjectWriter().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedExecutionException("Writing to JSON failed", (Throwable)e);
        }
    }
}

