/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.impl.job;

import io.camunda.zeebe.gateway.impl.broker.PartitionIdIterator;

public class InflightActivateJobsRequestState {
    private final PartitionIdIterator iterator;
    private int remainingAmount;
    private boolean pollPrevPartition;
    private boolean resourceExhaustedWasPresent;

    public InflightActivateJobsRequestState(PartitionIdIterator iterator, int remainingAmount) {
        this.iterator = iterator;
        this.remainingAmount = remainingAmount;
    }

    private boolean hasNextPartition() {
        return this.iterator.hasNext();
    }

    public int getCurrentPartition() {
        return this.iterator.getCurrentPartitionId();
    }

    public int getNextPartition() {
        return this.pollPrevPartition ? this.iterator.getCurrentPartitionId() : this.iterator.next().intValue();
    }

    public int getRemainingAmount() {
        return this.remainingAmount;
    }

    public void setRemainingAmount(int remainingAmount) {
        this.remainingAmount = remainingAmount;
    }

    public boolean wasResourceExhaustedPresent() {
        return this.resourceExhaustedWasPresent;
    }

    public void setResourceExhaustedWasPresent(boolean resourceExhaustedWasPresent) {
        this.resourceExhaustedWasPresent = resourceExhaustedWasPresent;
    }

    public void setPollPrevPartition(boolean pollPrevPartition) {
        this.pollPrevPartition = pollPrevPartition;
    }

    public boolean shouldActivateJobs() {
        return this.remainingAmount > 0 && (this.pollPrevPartition || this.hasNextPartition());
    }
}

