/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.impl.probes.health;

import java.io.File;
import java.net.URL;
import java.time.Duration;
import java.util.Objects;

public class HealthZeebeClientProperties {
    private Duration requestTimeout;
    private SecurityProperties securityProperties = new SecurityProperties();

    public Duration getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(Duration requestTimeout) {
        if (requestTimeout.toMillis() <= 0L) {
            throw new IllegalArgumentException("requestTimeout must be a positive value");
        }
        this.requestTimeout = requestTimeout;
    }

    public SecurityProperties getSecurityProperties() {
        return this.securityProperties;
    }

    public void setSecurityProperties(SecurityProperties securityProperties) {
        this.securityProperties = Objects.requireNonNull(securityProperties);
    }

    public int hashCode() {
        return Objects.hash(this.requestTimeout, this.securityProperties);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HealthZeebeClientProperties that = (HealthZeebeClientProperties)o;
        return Objects.equals(this.requestTimeout, that.requestTimeout) && Objects.equals(this.securityProperties, that.securityProperties);
    }

    public String toString() {
        return "HealthZeebeClientProperties{requestTimeout=" + this.requestTimeout + ", securityProperties=" + this.securityProperties + "}";
    }

    public static class SecurityProperties {
        private OAuthSecurityProperties oauthSecurityProperties;

        public OAuthSecurityProperties getOauthSecurityProperties() {
            return this.oauthSecurityProperties;
        }

        public void setOauthSecurityProperties(OAuthSecurityProperties oauthSecurityProperties) {
            this.oauthSecurityProperties = oauthSecurityProperties;
        }

        public int hashCode() {
            return Objects.hash(this.oauthSecurityProperties);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SecurityProperties that = (SecurityProperties)o;
            return Objects.equals(this.oauthSecurityProperties, that.oauthSecurityProperties);
        }

        public String toString() {
            return "SecurityProperties{oauthSecurityProperties=" + this.oauthSecurityProperties + "}";
        }

        public static class OAuthSecurityProperties {
            private String clientId;
            private String clientSecret;
            private String audience;
            private URL authorizationServer;
            private String credentialsCachePath;
            private File credentialsCache;
            private Duration connectTimeout;
            private Duration readTimeout;

            public String getClientId() {
                return this.clientId;
            }

            public void setClientId(String clientId) {
                this.clientId = clientId;
            }

            public String getClientSecret() {
                return this.clientSecret;
            }

            public void setClientSecret(String clientSecret) {
                this.clientSecret = clientSecret;
            }

            public String getAudience() {
                return this.audience;
            }

            public void setAudience(String audience) {
                this.audience = audience;
            }

            public URL getAuthorizationServer() {
                return this.authorizationServer;
            }

            public void setAuthorizationServer(URL authorizationServer) {
                this.authorizationServer = authorizationServer;
            }

            public String getCredentialsCachePath() {
                return this.credentialsCachePath;
            }

            public void setCredentialsCachePath(String credentialsCachePath) {
                this.credentialsCachePath = credentialsCachePath;
            }

            public File getCredentialsCache() {
                return this.credentialsCache;
            }

            public void setCredentialsCache(File credentialsCache) {
                this.credentialsCache = credentialsCache;
            }

            public Duration getConnectTimeout() {
                return this.connectTimeout;
            }

            public void setConnectTimeout(Duration connectTimeout) {
                this.connectTimeout = connectTimeout;
            }

            public Duration getReadTimeout() {
                return this.readTimeout;
            }

            public void setReadTimeout(Duration readTimeout) {
                this.readTimeout = readTimeout;
            }

            public int hashCode() {
                return Objects.hash(this.clientId, this.clientSecret, this.audience, this.authorizationServer, this.credentialsCachePath, this.credentialsCache, this.connectTimeout, this.readTimeout);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                OAuthSecurityProperties that = (OAuthSecurityProperties)o;
                return Objects.equals(this.clientId, that.clientId) && Objects.equals(this.clientSecret, that.clientSecret) && Objects.equals(this.audience, that.audience) && Objects.equals(this.authorizationServer, that.authorizationServer) && Objects.equals(this.credentialsCachePath, that.credentialsCachePath) && Objects.equals(this.credentialsCache, that.credentialsCache) && Objects.equals(this.connectTimeout, that.connectTimeout) && Objects.equals(this.readTimeout, that.readTimeout);
            }

            public String toString() {
                return "OAuthSecurityProperties{clientId='" + this.clientId + "', audience='" + this.audience + "', authorizationServer=" + this.authorizationServer + ", credentialsCachePath='" + this.credentialsCachePath + "', credentialsCache=" + this.credentialsCache + ", connectTimeout=" + this.connectTimeout + ", readTimeout=" + this.readTimeout + "}";
            }
        }
    }
}

