/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.impl.probes.health;

import io.camunda.zeebe.client.CredentialsProvider;
import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.ZeebeClientBuilder;
import io.camunda.zeebe.client.impl.oauth.OAuthCredentialsProviderBuilder;
import io.camunda.zeebe.gateway.impl.configuration.AuthenticationCfg;
import io.camunda.zeebe.gateway.impl.configuration.GatewayCfg;
import io.camunda.zeebe.gateway.impl.probes.health.HealthZeebeClientProperties;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.util.Map;
import java.util.Objects;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;

public class ResponsiveHealthIndicator
implements HealthIndicator {
    private final GatewayCfg gatewayCfg;
    private final HealthZeebeClientProperties healthZeebeClientProperties;
    private ZeebeClient zeebeClient;

    public ResponsiveHealthIndicator(GatewayCfg gatewayCfg, HealthZeebeClientProperties healthZeebeClientProperties) {
        this.gatewayCfg = Objects.requireNonNull(gatewayCfg);
        this.healthZeebeClientProperties = Objects.requireNonNull(healthZeebeClientProperties);
    }

    GatewayCfg getGatewayCfg() {
        return this.gatewayCfg;
    }

    HealthZeebeClientProperties getHealthZeebeClientProperties() {
        return this.healthZeebeClientProperties;
    }

    public Health health() {
        Health.Builder resultBuilder;
        this.initZeebeClient();
        if (this.zeebeClient == null) {
            resultBuilder = Health.unknown();
        } else {
            try {
                this.zeebeClient.newTopologyRequest().send().get();
                resultBuilder = Health.up();
            }
            catch (Throwable t) {
                resultBuilder = this.gatewayCfg.getSecurity().getAuthentication().getMode() != AuthenticationCfg.AuthMode.NONE && t.getCause() instanceof StatusRuntimeException && ((StatusRuntimeException)t.getCause()).getStatus().getCode().equals((Object)Status.Code.UNAUTHENTICATED) ? Health.up() : Health.down().withException(t);
            }
        }
        return resultBuilder.withDetails(Map.of("timeOut", this.healthZeebeClientProperties.getRequestTimeout(), "healthZeebeClientProperties", this.healthZeebeClientProperties)).build();
    }

    void initZeebeClient() {
        if (this.zeebeClient == null && this.gatewayCfg.isInitialized()) {
            this.zeebeClient = ResponsiveHealthIndicator.createZeebeClient(this.gatewayCfg, this.healthZeebeClientProperties);
        }
    }

    public ZeebeClient getZeebeClient() {
        return this.zeebeClient;
    }

    void setZeebeClient(ZeebeClient zeebeClient) {
        this.zeebeClient = zeebeClient;
    }

    static ZeebeClient createZeebeClient(GatewayCfg gatewayCfg, HealthZeebeClientProperties healthZeebeClientProperties) {
        String gatewayAddress = ResponsiveHealthIndicator.getContactPoint(gatewayCfg);
        ZeebeClientBuilder clientBuilder = ZeebeClient.newClientBuilder().gatewayAddress(gatewayAddress).defaultRequestTimeout(healthZeebeClientProperties.getRequestTimeout());
        clientBuilder = gatewayCfg.getSecurity().isEnabled() ? clientBuilder.caCertificatePath(gatewayCfg.getSecurity().getCertificateChainPath().getAbsolutePath()) : clientBuilder.usePlaintext();
        HealthZeebeClientProperties.SecurityProperties.OAuthSecurityProperties oauthSecurityProperties = healthZeebeClientProperties.getSecurityProperties().getOauthSecurityProperties();
        if (oauthSecurityProperties != null) {
            clientBuilder = clientBuilder.credentialsProvider((CredentialsProvider)new OAuthCredentialsProviderBuilder().clientId(oauthSecurityProperties.getClientId()).clientSecret(oauthSecurityProperties.getClientSecret()).credentialsCachePath(oauthSecurityProperties.getCredentialsCachePath()).connectTimeout(oauthSecurityProperties.getConnectTimeout()).authorizationServerUrl(oauthSecurityProperties.getAuthorizationServer().toString()).audience(oauthSecurityProperties.getAudience()).readTimeout(oauthSecurityProperties.getReadTimeout()).build());
        }
        return clientBuilder.build();
    }

    static String getContactPoint(GatewayCfg gatewayCfg) {
        String host = gatewayCfg.getNetwork().getHost();
        int port = gatewayCfg.getNetwork().getPort();
        return host + ":" + port;
    }
}

