/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.impl.probes.liveness;

import io.camunda.zeebe.gateway.impl.probes.health.HealthZeebeClientProperties;
import io.camunda.zeebe.util.health.AbstractDelayedHealthIndicatorProperties;
import java.time.Duration;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="management.health.liveness.gateway-responsive")
public class LivenessResponsiveHealthIndicatorProperties
extends AbstractDelayedHealthIndicatorProperties {
    private HealthZeebeClientProperties healthZeebeClientProperties = new HealthZeebeClientProperties();

    public LivenessResponsiveHealthIndicatorProperties() {
        this.healthZeebeClientProperties.setRequestTimeout(Duration.ofSeconds(5L));
    }

    protected Duration getDefaultMaxDowntime() {
        return Duration.ofMinutes(10L);
    }

    public void setRequestTimeout(Duration requestTimeout) {
        this.healthZeebeClientProperties.setRequestTimeout(requestTimeout);
    }

    public HealthZeebeClientProperties getHealthZeebeClientProperties() {
        return this.healthZeebeClientProperties;
    }

    public void setHealthZeebeClientProperties(HealthZeebeClientProperties healthZeebeClientProperties) {
        this.healthZeebeClientProperties = healthZeebeClientProperties;
    }
}

