/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.interceptors.impl;

import io.camunda.identity.sdk.Identity;
import io.camunda.identity.sdk.IdentityConfiguration;
import io.camunda.identity.sdk.authentication.exception.TokenVerificationException;
import io.camunda.zeebe.gateway.impl.configuration.IdentityCfg;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IdentityInterceptor
implements ServerInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdentityInterceptor.class);
    private static final Metadata.Key<String> AUTH_KEY = Metadata.Key.of((String)"Authorization", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private final Identity identity;

    public IdentityInterceptor(IdentityCfg config) {
        this(IdentityInterceptor.createIdentity(config));
    }

    IdentityInterceptor(Identity identity) {
        this.identity = identity;
    }

    private static Identity createIdentity(IdentityCfg config) {
        return new Identity(new IdentityConfiguration.Builder().withIssuerBackendUrl(config.getIssuerBackendUrl()).withAudience(config.getAudience()).withType(config.getType().name()).build());
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        MethodDescriptor methodDescriptor = call.getMethodDescriptor();
        String token = (String)headers.get(AUTH_KEY);
        if (token == null) {
            LOGGER.debug("Denying call {} as no token was provided", (Object)methodDescriptor.getFullMethodName());
            return this.deny(call, Status.UNAUTHENTICATED.augmentDescription("Expected bearer token at header with key [%s], but found nothing".formatted(AUTH_KEY.name())));
        }
        try {
            this.identity.authentication().verifyToken(token.replaceFirst("^Bearer ", ""));
        }
        catch (TokenVerificationException e) {
            LOGGER.debug("Denying call {} as the token could not be fully verified. Error message: {}", (Object)methodDescriptor.getFullMethodName(), (Object)e.getMessage());
            return this.deny(call, Status.UNAUTHENTICATED.augmentDescription("Failed to parse bearer token, see cause for details").withCause((Throwable)e));
        }
        return next.startCall(call, headers);
    }

    private <ReqT> ServerCall.Listener<ReqT> deny(ServerCall<ReqT, ?> call, Status status) {
        call.close(status, new Metadata());
        return new ServerCall.Listener<ReqT>(){};
    }
}

