/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.exporter;

import io.camunda.zeebe.exporter.RecordSequence;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.ValueType;
import java.util.EnumMap;
import java.util.Map;

public final class ElasticsearchRecordCounters {
    private static final long INITIAL_RECORD_COUNTER = 0L;
    private final Map<ValueType, Long> recordCountersByValueType;

    public ElasticsearchRecordCounters() {
        this.recordCountersByValueType = new EnumMap<ValueType, Long>(ValueType.class);
    }

    public ElasticsearchRecordCounters(Map<ValueType, Long> recordCounters) {
        this.recordCountersByValueType = new EnumMap<ValueType, Long>(recordCounters);
    }

    public RecordSequence getNextRecordSequence(Record<?> record) {
        ValueType valueType = record.getValueType();
        long recordCounter = this.recordCountersByValueType.getOrDefault(valueType, 0L);
        long nextCounter = recordCounter + 1L;
        return new RecordSequence(record.getPartitionId(), nextCounter);
    }

    public void updateRecordCounters(Record<?> record, RecordSequence recordSequence) {
        ValueType valueType = record.getValueType();
        long counter = recordSequence.counter();
        this.recordCountersByValueType.put(valueType, counter);
    }

    public Map<ValueType, Long> getRecordCounters() {
        return this.recordCountersByValueType;
    }
}

