/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.journal.file;

import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import io.prometheus.client.Histogram;

final class JournalMetrics {
    private static final String NAMESPACE = "atomix";
    private static final String PARTITION_LABEL = "partition";
    private static final Histogram SEGMENT_CREATION_TIME = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().namespace("atomix")).name("segment_creation_time")).help("Time spend to create a new segment")).labelNames(new String[]{"partition"})).register();
    private static final Histogram SEGMENT_TRUNCATE_TIME = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().namespace("atomix")).name("segment_truncate_time")).help("Time spend to truncate a segment")).labelNames(new String[]{"partition"})).register();
    private static final Histogram SEGMENT_FLUSH_TIME = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().namespace("atomix")).name("segment_flush_time")).help("Time spend to flush segment to disk")).labelNames(new String[]{"partition"})).register();
    private static final Histogram JOURNAL_FLUSH_TIME = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().namespace("atomix")).name("journal_flush_time")).help("Time spend to flush all dirty segments to disk")).labelNames(new String[]{"partition"})).register();
    private static final Gauge SEGMENT_COUNT = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("atomix")).name("segment_count")).help("Number of segments")).labelNames(new String[]{"partition"})).register();
    private static final Gauge JOURNAL_OPEN_DURATION = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("atomix")).name("journal_open_time")).help("Time taken to open the journal")).labelNames(new String[]{"partition"})).register();
    private static final Histogram SEGMENT_ALLOCATION_TIME = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().namespace("atomix")).name("segment_allocation_time")).help("Time spent to allocate a new segment")).labelNames(new String[]{"partition"})).register();
    private static final Counter APPEND_DATA_RATE = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().namespace("atomix")).name("journal_append_data_rate")).help("The rate in KiB at which we append data to the journal")).labelNames(new String[]{"partition"})).register();
    private static final Counter APPEND_RATE = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().namespace("atomix")).name("journal_append_rate")).help("The rate at which we append entries in the journal, by entry count")).labelNames(new String[]{"partition"})).register();
    private static final Histogram APPEND_LATENCY = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().namespace("atomix")).name("journal_append_latency")).help("Distribution of time spent appending journal records, excluding flushing")).labelNames(new String[]{"partition"})).register();
    private final Histogram.Child segmentCreationTime;
    private final Histogram.Child segmentTruncateTime;
    private final Histogram.Child segmentFlushTime;
    private final Histogram.Child journalFlushTime;
    private final Gauge.Child segmentCount;
    private final Gauge.Child journalOpenTime;
    private final Histogram.Child segmentAllocationTime;
    private final Histogram.Child appendLatency;
    private final Counter.Child appendRate;
    private final Counter.Child appendDataRate;

    JournalMetrics(String partitionId) {
        this.segmentCreationTime = (Histogram.Child)SEGMENT_CREATION_TIME.labels(new String[]{partitionId});
        this.segmentTruncateTime = (Histogram.Child)SEGMENT_TRUNCATE_TIME.labels(new String[]{partitionId});
        this.segmentFlushTime = (Histogram.Child)SEGMENT_FLUSH_TIME.labels(new String[]{partitionId});
        this.journalFlushTime = (Histogram.Child)JOURNAL_FLUSH_TIME.labels(new String[]{partitionId});
        this.segmentCount = (Gauge.Child)SEGMENT_COUNT.labels(new String[]{partitionId});
        this.journalOpenTime = (Gauge.Child)JOURNAL_OPEN_DURATION.labels(new String[]{partitionId});
        this.segmentAllocationTime = (Histogram.Child)SEGMENT_ALLOCATION_TIME.labels(new String[]{partitionId});
        this.appendLatency = (Histogram.Child)APPEND_LATENCY.labels(new String[]{partitionId});
        this.appendRate = (Counter.Child)APPEND_RATE.labels(new String[]{partitionId});
        this.appendDataRate = (Counter.Child)APPEND_DATA_RATE.labels(new String[]{partitionId});
    }

    void observeSegmentCreation(Runnable segmentCreation) {
        this.segmentCreationTime.time(segmentCreation);
    }

    Histogram.Timer observeSegmentFlush() {
        return this.segmentFlushTime.startTimer();
    }

    Histogram.Timer observeJournalFlush() {
        return this.journalFlushTime.startTimer();
    }

    void observeSegmentTruncation(Runnable segmentTruncation) {
        this.segmentTruncateTime.time(segmentTruncation);
    }

    Gauge.Timer startJournalOpenDurationTimer() {
        return this.journalOpenTime.startTimer();
    }

    void incSegmentCount() {
        this.segmentCount.inc();
    }

    void decSegmentCount() {
        this.segmentCount.dec();
    }

    Histogram.Timer observeSegmentAllocation() {
        return this.segmentAllocationTime.startTimer();
    }

    void observeAppend(long appendedBytes) {
        this.appendRate.inc();
        this.appendDataRate.inc((double)((float)appendedBytes / 1024.0f));
    }

    Histogram.Timer observeAppendLatency() {
        return this.appendLatency.startTimer();
    }
}

