/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.journal.file;

import com.google.common.base.Preconditions;
import io.camunda.zeebe.journal.CorruptedJournalException;
import io.camunda.zeebe.journal.file.DescriptorMetadataDecoder;
import io.camunda.zeebe.journal.file.DescriptorMetadataEncoder;
import io.camunda.zeebe.journal.file.MessageHeaderDecoder;
import io.camunda.zeebe.journal.file.MessageHeaderEncoder;
import io.camunda.zeebe.journal.file.SegmentDescriptorDecoder;
import io.camunda.zeebe.journal.file.SegmentDescriptorEncoder;
import io.camunda.zeebe.journal.file.UnknownVersionException;
import io.camunda.zeebe.journal.util.ChecksumGenerator;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

final class SegmentDescriptor {
    private static final int VERSION_LENGTH = 1;
    private static final byte CUR_VERSION = 2;
    private static final byte NO_META_VERSION = 1;
    private static final int[] VERSION_LENGTHS = new int[]{29, SegmentDescriptor.getEncodingLength()};
    private long id;
    private long index;
    private int maxSegmentSize;
    private int encodedLength;
    private long checksum;
    private final DescriptorMetadataEncoder metadataEncoder = new DescriptorMetadataEncoder();
    private final DescriptorMetadataDecoder metadataDecoder = new DescriptorMetadataDecoder();
    private final SegmentDescriptorDecoder segmentDescriptorDecoder = new SegmentDescriptorDecoder();
    private final MessageHeaderDecoder headerDecoder = new MessageHeaderDecoder();
    private final MutableDirectBuffer directBuffer = new UnsafeBuffer();
    private final SegmentDescriptorEncoder segmentDescriptorEncoder = new SegmentDescriptorEncoder();
    private final MessageHeaderEncoder headerEncoder = new MessageHeaderEncoder();
    private final ChecksumGenerator checksumGen = new ChecksumGenerator();

    SegmentDescriptor(ByteBuffer buffer) {
        this.directBuffer.wrap(buffer);
        byte version = this.directBuffer.getByte(0);
        if (version == 2) {
            this.readV2Descriptor(this.directBuffer);
        } else if (version == 1) {
            this.readV1Descriptor(this.directBuffer);
        } else {
            throw new CorruptedJournalException(String.format("Expected version to be one [%d %d] but read %d instead.", (byte)1, (byte)2, version));
        }
    }

    private SegmentDescriptor(long id, long index, int maxSegmentSize) {
        this.id = id;
        this.index = index;
        this.maxSegmentSize = maxSegmentSize;
        this.encodedLength = SegmentDescriptor.getEncodingLength();
    }

    private void readV1Descriptor(MutableDirectBuffer buffer) {
        this.validateHeader(buffer, 1, this.segmentDescriptorDecoder.sbeSchemaId(), this.segmentDescriptorDecoder.sbeTemplateId());
        this.readDescriptor(buffer, 1);
    }

    private void readV2Descriptor(MutableDirectBuffer buffer) {
        this.validateHeader(buffer, 1, this.metadataDecoder.sbeSchemaId(), this.metadataDecoder.sbeTemplateId());
        int descHeaderOffset = this.readChecksum(buffer, 1);
        this.validateHeader(buffer, descHeaderOffset, this.segmentDescriptorDecoder.sbeSchemaId(), this.segmentDescriptorDecoder.sbeTemplateId());
        int totalLength = this.readDescriptor(buffer, descHeaderOffset);
        int descriptorLength = totalLength - descHeaderOffset;
        this.validateChecksum(buffer, descHeaderOffset, descriptorLength);
    }

    private void validateChecksum(MutableDirectBuffer buffer, int descHeaderOffset, int descriptorLength) {
        ByteBuffer slice = ByteBuffer.allocate(descriptorLength);
        buffer.getBytes(descHeaderOffset, slice, descriptorLength);
        long computedChecksum = this.checksumGen.compute(slice, 0, descriptorLength);
        if (computedChecksum != this.checksum) {
            throw new CorruptedJournalException("Descriptor doesn't match checksum (possibly due to corruption).");
        }
    }

    private int readDescriptor(MutableDirectBuffer buffer, int offset) {
        this.headerDecoder.wrap((DirectBuffer)buffer, offset);
        this.segmentDescriptorDecoder.wrap((DirectBuffer)this.directBuffer, offset + this.headerDecoder.encodedLength(), this.headerDecoder.blockLength(), this.headerDecoder.version());
        this.id = this.segmentDescriptorDecoder.id();
        this.index = this.segmentDescriptorDecoder.index();
        this.maxSegmentSize = this.segmentDescriptorDecoder.maxSegmentSize();
        this.encodedLength = offset + this.headerDecoder.encodedLength() + this.segmentDescriptorDecoder.encodedLength();
        return this.encodedLength;
    }

    private int readChecksum(MutableDirectBuffer buffer, int offset) {
        this.headerDecoder.wrap((DirectBuffer)buffer, offset);
        this.metadataDecoder.wrap((DirectBuffer)buffer, offset + this.headerDecoder.encodedLength(), this.headerDecoder.blockLength(), this.headerDecoder.version());
        this.checksum = this.metadataDecoder.checksum();
        return offset + this.headerDecoder.encodedLength() + this.metadataDecoder.encodedLength();
    }

    private void validateHeader(MutableDirectBuffer buffer, int offset, int schemaId, int templateId) {
        this.headerDecoder.wrap((DirectBuffer)buffer, offset);
        if (this.headerDecoder.schemaId() != schemaId || this.headerDecoder.templateId() != templateId) {
            throw new CorruptedJournalException(String.format("Cannot read header. Read schema and template ids ('%d' and '%d') don't match expected '%d' and %d'.", this.headerDecoder.schemaId(), this.headerDecoder.templateId(), schemaId, templateId));
        }
    }

    int length() {
        return this.encodedLength;
    }

    static int getEncodingLength() {
        return 45;
    }

    static int getEncodingLengthForVersion(byte version) {
        if (version == 0 || version > VERSION_LENGTHS.length) {
            throw new UnknownVersionException(String.format("Expected version byte to be one [%d %d] but got %d instead.", (byte)1, (byte)2, version));
        }
        return VERSION_LENGTHS[version - 1];
    }

    static Builder builder() {
        return new Builder();
    }

    long id() {
        return this.id;
    }

    long index() {
        return this.index;
    }

    int maxSegmentSize() {
        return this.maxSegmentSize;
    }

    SegmentDescriptor copyTo(ByteBuffer buffer) {
        this.directBuffer.wrap(buffer);
        this.directBuffer.putByte(0, (byte)2);
        int descHeaderOffset = 17;
        this.segmentDescriptorEncoder.wrapAndApplyHeader(this.directBuffer, 17, this.headerEncoder).id(this.id).index(this.index).maxSegmentSize(this.maxSegmentSize);
        long checksum = this.checksumGen.compute(buffer, 17, this.headerEncoder.encodedLength() + this.segmentDescriptorEncoder.encodedLength());
        this.metadataEncoder.wrapAndApplyHeader(this.directBuffer, 1, this.headerEncoder).checksum(checksum);
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.index, this.maxSegmentSize);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SegmentDescriptor that = (SegmentDescriptor)o;
        return this.id == that.id && this.index == that.index && this.maxSegmentSize == that.maxSegmentSize;
    }

    public String toString() {
        return "JournalSegmentDescriptor{id=" + this.id + ", index=" + this.index + ", maxSegmentSize=" + this.maxSegmentSize + "}";
    }

    static final class Builder {
        private long id;
        private long index;
        private int maxSegmentSize;

        Builder() {
        }

        Builder withId(long id) {
            Preconditions.checkArgument((id > 0L ? 1 : 0) != 0, (Object)"id must be positive");
            this.id = id;
            return this;
        }

        Builder withIndex(long index) {
            Preconditions.checkArgument((index > 0L ? 1 : 0) != 0, (Object)"index must be positive");
            this.index = index;
            return this;
        }

        Builder withMaxSegmentSize(int maxSegmentSize) {
            Preconditions.checkArgument((maxSegmentSize > 0 ? 1 : 0) != 0, (Object)"maxSegmentSize must be positive");
            this.maxSegmentSize = maxSegmentSize;
            return this;
        }

        SegmentDescriptor build() {
            return new SegmentDescriptor(this.id, this.index, this.maxSegmentSize);
        }
    }
}

