/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.journal.file;

import com.google.common.base.Preconditions;
import java.io.File;
import java.nio.file.Path;

public final class SegmentFile {
    private static int deletedFileIndex = 0;
    private static final char PART_SEPARATOR = '-';
    private static final char EXTENSION_SEPARATOR = '.';
    private static final String EXTENSION = "log";
    private static final String DELETE_EXTENSION = "deleted";
    private static final char DELETE_EXTENSION_SEPARATOR = '_';
    private final File file;
    private Path fileMarkedForDeletion;

    SegmentFile(File file) {
        this.file = file;
    }

    public static boolean isSegmentFile(String name, File file) {
        return SegmentFile.isSegmentFile(name, file.getName());
    }

    public static boolean isSegmentFile(String journalName, String fileName) {
        Preconditions.checkNotNull((Object)journalName, (Object)"journalName cannot be null");
        Preconditions.checkNotNull((Object)fileName, (Object)"fileName cannot be null");
        if (SegmentFile.getSegmentIdFromPath(fileName) == -1) {
            return false;
        }
        return fileName.startsWith(journalName);
    }

    static int getSegmentIdFromPath(String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
        int partSeparator = name.lastIndexOf(45);
        int extensionSeparator = name.lastIndexOf(46);
        if (extensionSeparator == -1 || partSeparator == -1 || extensionSeparator < partSeparator || !name.endsWith(EXTENSION)) {
            return -1;
        }
        try {
            return Integer.parseInt(name.substring(partSeparator + 1, extensionSeparator));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    static File createSegmentFile(String name, File directory, long id) {
        return new File(directory, String.format("%s%s%d%s%s", Preconditions.checkNotNull((Object)name, (Object)"name cannot be null"), Character.valueOf('-'), id, Character.valueOf('.'), EXTENSION));
    }

    public File file() {
        return this.file;
    }

    public String name() {
        return this.file.getName();
    }

    public Path getFileMarkedForDeletion() {
        if (this.fileMarkedForDeletion == null) {
            String renamedFileName = String.format("%s%c%d-%s", this.file.getName(), Character.valueOf('_'), deletedFileIndex++, DELETE_EXTENSION);
            this.fileMarkedForDeletion = Path.of(this.file.getParent(), renamedFileName);
        }
        return this.fileMarkedForDeletion;
    }

    public static boolean isDeletedSegmentFile(String journalName, String fileName) {
        Preconditions.checkNotNull((Object)journalName, (Object)"journalName cannot be null");
        Preconditions.checkNotNull((Object)fileName, (Object)"fileName cannot be null");
        if (!fileName.endsWith(DELETE_EXTENSION)) {
            return false;
        }
        int deleteExtensionIndex = fileName.lastIndexOf(95);
        return SegmentFile.isSegmentFile(journalName, fileName.substring(0, deleteExtensionIndex));
    }
}

