/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.journal.file;

import io.camunda.zeebe.journal.CorruptedJournalException;
import io.camunda.zeebe.journal.JournalException;
import io.camunda.zeebe.journal.JournalRecord;
import io.camunda.zeebe.journal.file.FrameUtil;
import io.camunda.zeebe.journal.file.JournalIndex;
import io.camunda.zeebe.journal.file.JournalMetrics;
import io.camunda.zeebe.journal.file.Segment;
import io.camunda.zeebe.journal.record.JournalRecordReaderUtil;
import io.camunda.zeebe.journal.record.JournalRecordSerializer;
import io.camunda.zeebe.journal.record.PersistedJournalRecord;
import io.camunda.zeebe.journal.record.RecordData;
import io.camunda.zeebe.journal.record.RecordMetadata;
import io.camunda.zeebe.journal.record.SBESerializer;
import io.camunda.zeebe.journal.util.ChecksumGenerator;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.buffer.BufferWriter;
import io.camunda.zeebe.util.buffer.DirectBufferWriter;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SegmentWriter {
    private static final Logger LOG = LoggerFactory.getLogger(SegmentWriter.class);
    private final MappedByteBuffer buffer;
    private final Segment segment;
    private final JournalIndex index;
    private final long firstIndex;
    private final long firstAsqn;
    private long lastAsqn;
    private JournalRecord lastEntry;
    private final JournalRecordReaderUtil recordUtil;
    private final ChecksumGenerator checksumGenerator = new ChecksumGenerator();
    private final JournalRecordSerializer serializer = new SBESerializer();
    private final MutableDirectBuffer writeBuffer = new UnsafeBuffer();
    private final int descriptorLength;
    private final JournalMetrics metrics;

    SegmentWriter(MappedByteBuffer buffer, Segment segment, JournalIndex index, long lastWrittenAsqn, JournalMetrics metrics) {
        this.segment = segment;
        this.descriptorLength = segment.descriptor().length();
        this.recordUtil = new JournalRecordReaderUtil(this.serializer);
        this.index = index;
        this.firstIndex = segment.index();
        this.buffer = buffer;
        this.writeBuffer.wrap((ByteBuffer)buffer);
        this.firstAsqn = lastWrittenAsqn + 1L;
        this.lastAsqn = lastWrittenAsqn;
        this.metrics = metrics;
        this.reset(0L, false);
    }

    long getLastIndex() {
        return this.lastEntry != null ? this.lastEntry.index() : this.segment.index() - 1L;
    }

    long getNextIndex() {
        if (this.lastEntry != null) {
            return this.lastEntry.index() + 1L;
        }
        return this.firstIndex;
    }

    public long getLastAsqn() {
        return this.lastAsqn;
    }

    Either<JournalException.SegmentFull, JournalRecord> append(JournalRecord record) {
        return this.append(record.index(), record.asqn(), (BufferWriter)new DirectBufferWriter().wrap(record.data()), record.checksum());
    }

    Either<JournalException.SegmentFull, JournalRecord> append(long asqn, BufferWriter recordDataWriter) {
        return this.append(this.getNextIndex(), asqn, recordDataWriter, null);
    }

    private Either<JournalException.SegmentFull, JournalRecord> append(Long entryIndex, long asqn, BufferWriter recordDataWriter, Long expectedChecksum) {
        long nextIndex = this.getNextIndex();
        if (entryIndex != nextIndex) {
            throw new JournalException.InvalidIndex(String.format("The record index is not sequential. Expected the next index to be %d, but the record to append has index %d", nextIndex, entryIndex));
        }
        if (asqn != -1L && asqn <= this.lastAsqn) {
            throw new JournalException.InvalidAsqn(String.format("The records asqn is not big enough. Expected it to be bigger than %d but was %d", this.lastAsqn, asqn));
        }
        int startPosition = this.buffer.position();
        int frameLength = FrameUtil.getLength();
        int metadataLength = this.serializer.getMetadataLength();
        Either<JournalException.SegmentFull, Integer> writeResult = this.writeRecord(this.getNextIndex(), asqn, startPosition + frameLength + metadataLength, recordDataWriter);
        if (writeResult.isLeft()) {
            this.buffer.position(startPosition);
            return Either.left((Object)((JournalException.SegmentFull)writeResult.getLeft()));
        }
        int recordLength = (Integer)writeResult.get();
        long checksum = this.checksumGenerator.compute(this.buffer, startPosition + frameLength + metadataLength, recordLength);
        if (expectedChecksum != null && expectedChecksum != checksum) {
            this.buffer.position(startPosition);
            throw new JournalException.InvalidChecksum(String.format("Failed to append record. Checksum %d does not match the expected %d.", checksum, expectedChecksum));
        }
        this.writeMetadata(startPosition, frameLength, recordLength, checksum);
        this.updateLastWrittenEntry(startPosition, frameLength, metadataLength);
        FrameUtil.writeVersion(this.buffer, startPosition);
        int appendedBytes = frameLength + metadataLength + recordLength;
        this.buffer.position(startPosition + appendedBytes);
        this.metrics.observeAppend(appendedBytes);
        return Either.right((Object)this.lastEntry);
    }

    private void updateLastWrittenEntry(int startPosition, int frameLength, int metadataLength) {
        RecordMetadata metadata = this.serializer.readMetadata((DirectBuffer)this.writeBuffer, startPosition + frameLength);
        RecordData data = this.serializer.readData((DirectBuffer)this.writeBuffer, startPosition + frameLength + metadataLength);
        this.lastEntry = new PersistedJournalRecord(metadata, data);
        this.updateLastAsqn(this.lastEntry.asqn());
        this.index.index(this.lastEntry, startPosition);
    }

    private void updateLastAsqn(long asqn) {
        this.lastAsqn = asqn != -1L ? asqn : this.lastAsqn;
    }

    private void writeMetadata(int startPosition, int frameLength, int recordLength, long checksum) {
        RecordMetadata recordMetadata = new RecordMetadata(checksum, recordLength);
        this.serializer.writeMetadata(recordMetadata, this.writeBuffer, startPosition + frameLength);
    }

    private Either<JournalException.SegmentFull, Integer> writeRecord(long index, long asqn, int offset, BufferWriter recordDataWriter) {
        Either<BufferOverflowException, Integer> recordLength = this.serializer.writeData(index, asqn, recordDataWriter, this.writeBuffer, offset);
        if (recordLength.isLeft()) {
            return Either.left((Object)new JournalException.SegmentFull("Not enough space to write record"));
        }
        int nextEntryOffset = offset + (Integer)recordLength.get();
        this.invalidateNextEntry(nextEntryOffset);
        return Either.right((Object)((Integer)recordLength.get()));
    }

    private void invalidateNextEntry(int position) {
        if (position >= this.buffer.capacity()) {
            return;
        }
        FrameUtil.markAsIgnored(this.buffer, position);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reset(long index, boolean detectCorruption) {
        this.buffer.position(this.descriptorLength);
        this.buffer.mark();
        int position = this.buffer.position();
        try {
            for (long nextIndex = this.firstIndex; (index == 0L || nextIndex <= index) && FrameUtil.hasValidVersion(this.buffer); ++nextIndex) {
                FrameUtil.readVersion(this.buffer);
                this.lastEntry = this.recordUtil.read(this.buffer, nextIndex);
                this.updateLastAsqn(this.lastEntry.asqn());
                this.index.index(this.lastEntry, position);
                this.buffer.mark();
                position = this.buffer.position();
            }
        }
        catch (BufferUnderflowException bufferUnderflowException) {
        }
        catch (CorruptedJournalException e) {
            if (detectCorruption) {
                throw e;
            }
            this.resetPartiallyWrittenEntry(e, position);
        }
        finally {
            this.buffer.reset();
        }
    }

    private void resetPartiallyWrittenEntry(CorruptedJournalException e, int position) {
        LOG.debug("{} Found a corrupted or partially written entry at position {}. Considering it as a partially written entry and resetting the position.", (Object)e.getMessage(), (Object)position);
        FrameUtil.markAsIgnored(this.buffer, position);
        this.buffer.position(position);
        this.buffer.mark();
    }

    public void truncate(long index) {
        if (index >= this.getLastIndex()) {
            return;
        }
        this.lastEntry = null;
        this.index.deleteAfter(index);
        this.lastAsqn = this.firstAsqn - 1L;
        if (index < this.segment.index()) {
            this.buffer.position(this.descriptorLength);
            this.invalidateNextEntry(this.descriptorLength);
        } else {
            this.reset(index, true);
            this.invalidateNextEntry(this.buffer.position());
        }
    }
}

