/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.backup.gcs;

import io.camunda.zeebe.backup.gcs.manifest.Manifest;

public abstract class GcsBackupStoreException
extends RuntimeException {
    public GcsBackupStoreException(String message) {
        super(message);
    }

    public GcsBackupStoreException(String message, Throwable cause) {
        super(message, cause);
    }

    public static class ConfigurationException
    extends GcsBackupStoreException {
        public ConfigurationException(String message) {
            super(message);
        }

        public ConfigurationException(String message, Exception cause) {
            super(message, cause);
        }

        public static final class CouldNotAccessBucketException
        extends ConfigurationException {
            public CouldNotAccessBucketException(String bucketName, Exception cause) {
                super("Bucket %s does not exist".formatted(bucketName), cause);
            }
        }
    }

    public static class UnexpectedManifestState
    extends GcsBackupStoreException {
        public UnexpectedManifestState(Manifest.StatusCode expected, Manifest.StatusCode actual) {
            super("Expected manifest in state '%s', but was in '%s'".formatted(new Object[]{expected, actual}));
        }

        public UnexpectedManifestState(String message) {
            super(message);
        }
    }

    public static class InvalidPersistedManifestState
    extends GcsBackupStoreException {
        public InvalidPersistedManifestState(String errorMessage) {
            super(errorMessage);
        }
    }
}

