/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.metrics;

import io.atomix.raft.metrics.RaftMetrics;
import io.prometheus.client.Gauge;

public class RaftStartupMetrics
extends RaftMetrics {
    private static final Gauge START_DURATION = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("atomix")).labelNames(new String[]{"partitionGroupName", "partition"})).help("Time taken to start the partition server (in ms). This includes the bootstrap time.")).name("partition_server_startup_time")).register();
    private static final Gauge BOOTSTRAP_DURATION = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("atomix")).labelNames(new String[]{"partitionGroupName", "partition"})).help("Time taken to bootstrap the partition server (in ms)")).name("partition_server_bootstrap_time")).register();
    private final Gauge.Child startDuration;
    private final Gauge.Child bootstrapDuration;

    public RaftStartupMetrics(String partitionName) {
        super(partitionName);
        this.startDuration = (Gauge.Child)START_DURATION.labels(new String[]{this.partitionGroupName, this.partition});
        this.bootstrapDuration = (Gauge.Child)BOOTSTRAP_DURATION.labels(new String[]{this.partitionGroupName, this.partition});
    }

    public void observeStartupDuration(long durationMillis) {
        this.startDuration.set((double)durationMillis);
    }

    public void observeBootstrapDuration(long durationMillis) {
        this.bootstrapDuration.set((double)durationMillis);
    }
}

