/*
 * Decompiled with CFR 0.152.
 */
package me.dinowernli.grpc.prometheus;

import io.prometheus.client.CollectorRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class Configuration {
    private static double[] DEFAULT_LATENCY_BUCKETS = new double[]{0.001, 0.005, 0.01, 0.05, 0.075, 0.1, 0.25, 0.5, 1.0, 2.0, 5.0, 10.0};
    private final boolean isIncludeLatencyHistograms;
    private final CollectorRegistry collectorRegistry;
    private final double[] latencyBuckets;
    private final List<String> labelHeaders;
    private final boolean isAddCodeLabelToHistograms;

    public static Configuration cheapMetricsOnly() {
        return new Configuration(false, CollectorRegistry.defaultRegistry, DEFAULT_LATENCY_BUCKETS, new ArrayList<String>(), false);
    }

    public static Configuration allMetrics() {
        return new Configuration(true, CollectorRegistry.defaultRegistry, DEFAULT_LATENCY_BUCKETS, new ArrayList<String>(), false);
    }

    public Configuration withCollectorRegistry(CollectorRegistry collectorRegistry) {
        return new Configuration(this.isIncludeLatencyHistograms, collectorRegistry, this.latencyBuckets, this.labelHeaders, this.isAddCodeLabelToHistograms);
    }

    public Configuration withLatencyBuckets(double[] buckets) {
        return new Configuration(this.isIncludeLatencyHistograms, this.collectorRegistry, buckets, this.labelHeaders, this.isAddCodeLabelToHistograms);
    }

    public Configuration withLabelHeaders(List<String> headers) {
        ArrayList<String> newHeaders = new ArrayList<String>(this.labelHeaders);
        newHeaders.addAll(headers);
        return new Configuration(this.isIncludeLatencyHistograms, this.collectorRegistry, this.latencyBuckets, newHeaders, this.isAddCodeLabelToHistograms);
    }

    public Configuration withCodeLabelInLatencyHistogram() {
        return new Configuration(this.isIncludeLatencyHistograms, this.collectorRegistry, this.latencyBuckets, this.labelHeaders, true);
    }

    public boolean isIncludeLatencyHistograms() {
        return this.isIncludeLatencyHistograms;
    }

    public CollectorRegistry getCollectorRegistry() {
        return this.collectorRegistry;
    }

    public double[] getLatencyBuckets() {
        return this.latencyBuckets;
    }

    public List<String> getLabelHeaders() {
        return this.labelHeaders;
    }

    public boolean isAddCodeLabelToHistograms() {
        return this.isAddCodeLabelToHistograms;
    }

    public List<String> getSanitizedLabelHeaders() {
        return this.labelHeaders.stream().map(h -> h.replaceAll("-", "_")).collect(Collectors.toList());
    }

    private Configuration(boolean isIncludeLatencyHistograms, CollectorRegistry collectorRegistry, double[] latencyBuckets, List<String> labelHeaders, boolean isAddCodeLabelToHistograms) {
        this.isIncludeLatencyHistograms = isIncludeLatencyHistograms;
        this.collectorRegistry = collectorRegistry;
        this.latencyBuckets = latencyBuckets;
        this.labelHeaders = labelHeaders;
        this.isAddCodeLabelToHistograms = isAddCodeLabelToHistograms;
    }
}

