/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.graphql.data;

import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.graphql.GraphQlSourceBuilderCustomizer;
import org.springframework.graphql.execution.GraphQlSource;
import org.springframework.graphql.execution.RuntimeWiringConfigurer;

class GraphQlQuerydslSourceBuilderCustomizer<E, R>
implements GraphQlSourceBuilderCustomizer {
    private final BiFunction<List<E>, List<R>, RuntimeWiringConfigurer> wiringConfigurerFactory;
    private final List<E> executors;
    private final List<R> reactiveExecutors;

    GraphQlQuerydslSourceBuilderCustomizer(BiFunction<List<E>, List<R>, RuntimeWiringConfigurer> wiringConfigurerFactory, ObjectProvider<E> executors, ObjectProvider<R> reactiveExecutors) {
        this.wiringConfigurerFactory = wiringConfigurerFactory;
        this.executors = GraphQlQuerydslSourceBuilderCustomizer.asList(executors);
        this.reactiveExecutors = GraphQlQuerydslSourceBuilderCustomizer.asList(reactiveExecutors);
    }

    private static <T> List<T> asList(ObjectProvider<T> provider) {
        return provider != null ? provider.orderedStream().toList() : Collections.emptyList();
    }

    @Override
    public void customize(GraphQlSource.SchemaResourceBuilder builder) {
        if (!this.executors.isEmpty() || !this.reactiveExecutors.isEmpty()) {
            builder.configureRuntimeWiring(this.wiringConfigurerFactory.apply(this.executors, this.reactiveExecutors));
        }
    }
}

