/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.impl.log;

import io.camunda.zeebe.logstreams.impl.serializer.SequencedBatchSerializer;
import io.camunda.zeebe.logstreams.log.LogAppendEntry;
import io.camunda.zeebe.util.buffer.BufferWriter;
import java.util.List;
import java.util.Objects;
import org.agrona.MutableDirectBuffer;

public record SequencedBatch(long timestamp, long firstPosition, long sourcePosition, List<LogAppendEntry> entries, int length) implements BufferWriter
{
    public SequencedBatch(long timestamp, long firstPosition, long sourcePosition, List<LogAppendEntry> entries) {
        this(timestamp, firstPosition, sourcePosition, Objects.requireNonNull(entries, "must specify a list of entries"), SequencedBatchSerializer.calculateBatchSize(entries));
    }

    public int getLength() {
        return this.length;
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        SequencedBatchSerializer.serializeBatch(buffer, offset, this);
    }
}

