/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.db.impl.rocksdb.transaction;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.EnumSet;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksObject;
import org.rocksdb.Status;
import org.rocksdb.Transaction;

public final class RocksDbInternal {
    static final EnumSet<Status.Code> RECOVERABLE_ERROR_CODES = EnumSet.of(Status.Code.Ok, new Status.Code[]{Status.Code.Aborted, Status.Code.Expired, Status.Code.IOError, Status.Code.Busy, Status.Code.TimedOut, Status.Code.TryAgain, Status.Code.MergeInProgress});
    static Field nativeHandle;
    static Method putWithHandle;
    static Method getWithHandle;
    static Method removeWithHandle;

    private static void resolveInternalMethods() throws NoSuchFieldException, NoSuchMethodException {
        RocksDbInternal.nativeHandles();
        RocksDbInternal.putWithHandle();
        RocksDbInternal.getWithHandle();
        RocksDbInternal.removeWithHandle();
    }

    private static void nativeHandles() throws NoSuchFieldException {
        nativeHandle = RocksObject.class.getDeclaredField("nativeHandle_");
        nativeHandle.setAccessible(true);
    }

    private static void putWithHandle() throws NoSuchMethodException {
        putWithHandle = Transaction.class.getDeclaredMethod("put", Long.TYPE, byte[].class, Integer.TYPE, byte[].class, Integer.TYPE, Long.TYPE, Boolean.TYPE);
        putWithHandle.setAccessible(true);
    }

    private static void getWithHandle() throws NoSuchMethodException {
        getWithHandle = Transaction.class.getDeclaredMethod("get", Long.TYPE, Long.TYPE, byte[].class, Integer.TYPE, Long.TYPE);
        getWithHandle.setAccessible(true);
    }

    private static void removeWithHandle() throws NoSuchMethodException {
        removeWithHandle = Transaction.class.getDeclaredMethod("delete", Long.TYPE, byte[].class, Integer.TYPE, Long.TYPE, Boolean.TYPE);
        removeWithHandle.setAccessible(true);
    }

    static boolean isRocksDbExceptionRecoverable(RocksDBException rdbex) {
        Status status = rdbex.getStatus();
        return RECOVERABLE_ERROR_CODES.contains(status.getCode());
    }

    static {
        RocksDB.loadLibrary();
        try {
            RocksDbInternal.resolveInternalMethods();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

