/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.backup.s3.manifest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

@JsonDeserialize(using=Deserializer.class)
public record FileSet(Map<String, FileMetadata> files) {
    public static FileSet withoutMetadata(Set<String> fileNames) {
        Map<String, FileMetadata> savedFiles = fileNames.stream().collect(Collectors.toMap(String.class::cast, ignored -> FileMetadata.none()));
        return new FileSet(savedFiles);
    }

    public static FileSet empty() {
        return new FileSet(Map.of());
    }

    public Set<String> names() {
        return this.files.keySet();
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public record FileMetadata(Optional<String> compressionAlgorithm) {
        public static FileMetadata withCompression(String algorithm) {
            return new FileMetadata(Optional.of(algorithm));
        }

        public static FileMetadata none() {
            return new FileMetadata(Optional.empty());
        }
    }

    static final class Deserializer
    extends JsonDeserializer<FileSet> {
        private static final TypeReference<Map<String, FileMetadata>> WITH_METADATA = new TypeReference<Map<String, FileMetadata>>(){};
        private static final TypeReference<Set<String>> WITHOUT_METADATA = new TypeReference<Set<String>>(){};

        Deserializer() {
        }

        public FileSet deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            ObjectCodec codec = p.getCodec();
            if (p.currentToken() == JsonToken.START_ARRAY) {
                Set content = (Set)codec.readValue(p, WITHOUT_METADATA);
                return FileSet.withoutMetadata(content);
            }
            if (p.currentToken() == JsonToken.START_OBJECT) {
                try (JsonParser parser = codec.readTree(p).get("files").traverse(codec);){
                    Map content = (Map)parser.readValueAs(WITH_METADATA);
                    FileSet fileSet = new FileSet(content);
                    return fileSet;
                }
            }
            ctxt.handleUnexpectedToken(FileSet.class, p);
            return null;
        }
    }
}

