/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.bootstrap;

import io.camunda.zeebe.broker.bootstrap.BrokerStartupContext;
import io.camunda.zeebe.broker.system.monitoring.BrokerStepMetrics;
import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.scheduler.startup.StartupStep;
import io.prometheus.client.Gauge;
import java.util.Objects;
import java.util.function.Function;

final class BrokerStepMetricDecorator
implements StartupStep<BrokerStartupContext> {
    private final BrokerStepMetrics brokerStepMetrics;
    private final StartupStep<BrokerStartupContext> delegate;

    BrokerStepMetricDecorator(BrokerStepMetrics brokerStepMetrics, StartupStep<BrokerStartupContext> delegate) {
        this.brokerStepMetrics = Objects.requireNonNull(brokerStepMetrics);
        this.delegate = Objects.requireNonNull(delegate);
    }

    public String getName() {
        return this.delegate.getName();
    }

    public ActorFuture<BrokerStartupContext> startup(BrokerStartupContext brokerStartupContext) {
        return this.callDelegateAndUpdateTimer(brokerStartupContext, arg_0 -> this.delegate.startup(arg_0), this.brokerStepMetrics.createStartupTimer(this.getName()));
    }

    public ActorFuture<BrokerStartupContext> shutdown(BrokerStartupContext brokerStartupContext) {
        return this.callDelegateAndUpdateTimer(brokerStartupContext, arg_0 -> this.delegate.shutdown(arg_0), this.brokerStepMetrics.createCloseTimer(this.getName()));
    }

    private ActorFuture<BrokerStartupContext> callDelegateAndUpdateTimer(BrokerStartupContext brokerStartupContext, Function<BrokerStartupContext, ActorFuture<BrokerStartupContext>> functionToCall, Gauge.Timer timer) {
        try {
            ConcurrencyControl concurrencyControl = brokerStartupContext.getConcurrencyControl();
            ActorFuture<BrokerStartupContext> future = functionToCall.apply(brokerStartupContext);
            concurrencyControl.runOnCompletion(future, (ok, error) -> timer.close());
            return future;
        }
        catch (Exception e) {
            return CompletableActorFuture.completedExceptionally((Throwable)e);
        }
    }
}

