/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.bootstrap;

import io.atomix.utils.event.EventListener;
import io.camunda.zeebe.broker.bootstrap.AbstractBrokerStartupStep;
import io.camunda.zeebe.broker.bootstrap.BrokerStartupContext;
import io.camunda.zeebe.broker.clustering.ClusterServicesImpl;
import io.camunda.zeebe.broker.jobstream.JobStreamMetrics;
import io.camunda.zeebe.broker.jobstream.JobStreamService;
import io.camunda.zeebe.broker.jobstream.RemoteJobStreamer;
import io.camunda.zeebe.engine.processing.streamprocessor.ActivatedJob;
import io.camunda.zeebe.engine.processing.streamprocessor.JobActivationProperties;
import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.transport.TransportFactory;
import io.camunda.zeebe.transport.stream.api.RemoteStreamMetrics;
import io.camunda.zeebe.transport.stream.api.RemoteStreamService;
import io.camunda.zeebe.transport.stream.api.RemoteStreamer;
import java.util.Collection;
import java.util.Collections;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class JobStreamServiceStep
extends AbstractBrokerStartupStep {
    @Override
    void startupInternal(BrokerStartupContext brokerStartupContext, ConcurrencyControl concurrencyControl, ActorFuture<BrokerStartupContext> startupFuture) {
        ClusterServicesImpl clusterServices = brokerStartupContext.getClusterServices();
        RemoteStreamService remoteStreamService = new TransportFactory(brokerStartupContext.getActorSchedulingService()).createRemoteStreamServer(clusterServices.getCommunicationService(), DummyActivationProperties::new, (RemoteStreamMetrics)new JobStreamMetrics());
        remoteStreamService.start(brokerStartupContext.getActorSchedulingService(), concurrencyControl).onComplete((streamer, error) -> {
            if (error != null) {
                startupFuture.completeExceptionally(error);
            } else {
                JobStreamService jobStreamService = new JobStreamService((RemoteStreamService<JobActivationProperties, ActivatedJob>)remoteStreamService, new RemoteJobStreamer((RemoteStreamer<JobActivationProperties, ActivatedJob>)streamer, clusterServices.getEventService()));
                clusterServices.getMembershipService().addListener((EventListener)remoteStreamService);
                brokerStartupContext.setJobStreamService(jobStreamService);
                startupFuture.complete((Object)brokerStartupContext);
            }
        });
    }

    @Override
    void shutdownInternal(BrokerStartupContext brokerShutdownContext, ConcurrencyControl concurrencyControl, ActorFuture<BrokerStartupContext> shutdownFuture) {
        JobStreamService service = brokerShutdownContext.getJobStreamService();
        if (service != null) {
            service.closeAsync(concurrencyControl).onComplete((ok, error) -> {
                if (error != null) {
                    shutdownFuture.completeExceptionally(error);
                } else {
                    brokerShutdownContext.getClusterServices().getMembershipService().removeListener(service.remoteStreamService());
                    brokerShutdownContext.setJobStreamService(null);
                    shutdownFuture.complete((Object)brokerShutdownContext);
                }
            });
        }
    }

    public String getName() {
        return "JobStreamService";
    }

    private record DummyActivationProperties(DirectBuffer worker, long timeout, Collection<DirectBuffer> fetchVariables) implements JobActivationProperties
    {
        private DummyActivationProperties() {
            this((DirectBuffer)new UnsafeBuffer(), -1L, Collections.emptyList());
        }

        public void wrap(DirectBuffer buffer, int offset, int length) {
        }
    }
}

