/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system;

import io.atomix.cluster.ClusterMembershipService;
import io.atomix.cluster.messaging.ClusterEventService;
import io.atomix.cluster.messaging.MessagingService;
import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.gateway.Gateway;
import io.camunda.zeebe.gateway.impl.broker.BrokerClient;
import io.camunda.zeebe.gateway.impl.broker.BrokerClientImpl;
import io.camunda.zeebe.gateway.impl.configuration.GatewayCfg;
import io.camunda.zeebe.scheduler.ActorSchedulingService;
import io.camunda.zeebe.scheduler.future.ActorFuture;

public final class EmbeddedGatewayService
implements AutoCloseable {
    private final Gateway gateway;
    private final BrokerClientImpl brokerClient;

    public EmbeddedGatewayService(BrokerCfg configuration, ActorSchedulingService actorScheduler, MessagingService messagingService, ClusterMembershipService membershipService, ClusterEventService eventService) {
        this.brokerClient = new BrokerClientImpl(configuration.getGateway().getCluster().getRequestTimeout(), messagingService, membershipService, eventService, actorScheduler);
        this.gateway = new Gateway((GatewayCfg)configuration.getGateway(), (BrokerClient)this.brokerClient, actorScheduler);
    }

    @Override
    public void close() {
        if (this.gateway != null) {
            this.gateway.stop();
        }
    }

    public Gateway get() {
        return this.gateway;
    }

    public ActorFuture<Gateway> start() {
        this.brokerClient.start();
        return this.gateway.start();
    }
}

