/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster;

import com.google.common.base.MoreObjects;
import io.atomix.cluster.AtomixClusterBuilder;
import io.atomix.cluster.BootstrapService;
import io.atomix.cluster.ClusterConfig;
import io.atomix.cluster.ClusterMembershipService;
import io.atomix.cluster.ManagedClusterMembershipService;
import io.atomix.cluster.Member;
import io.atomix.cluster.discovery.BootstrapDiscoveryProvider;
import io.atomix.cluster.discovery.NodeDiscoveryConfig;
import io.atomix.cluster.discovery.NodeDiscoveryProvider;
import io.atomix.cluster.impl.DefaultClusterMembershipService;
import io.atomix.cluster.impl.DefaultNodeDiscoveryService;
import io.atomix.cluster.messaging.ClusterCommunicationService;
import io.atomix.cluster.messaging.ClusterEventService;
import io.atomix.cluster.messaging.ManagedClusterCommunicationService;
import io.atomix.cluster.messaging.ManagedClusterEventService;
import io.atomix.cluster.messaging.ManagedMessagingService;
import io.atomix.cluster.messaging.ManagedUnicastService;
import io.atomix.cluster.messaging.MessagingService;
import io.atomix.cluster.messaging.UnicastService;
import io.atomix.cluster.messaging.impl.DefaultClusterCommunicationService;
import io.atomix.cluster.messaging.impl.DefaultClusterEventService;
import io.atomix.cluster.messaging.impl.NettyMessagingService;
import io.atomix.cluster.messaging.impl.NettyUnicastService;
import io.atomix.cluster.protocol.GroupMembershipProtocol;
import io.atomix.utils.Managed;
import io.atomix.utils.Version;
import io.atomix.utils.concurrent.SingleThreadContext;
import io.atomix.utils.concurrent.ThreadContext;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtomixCluster
implements BootstrapService,
Managed<Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AtomixCluster.class);
    protected final ManagedMessagingService messagingService;
    protected final ManagedUnicastService unicastService;
    protected final NodeDiscoveryProvider discoveryProvider;
    protected final GroupMembershipProtocol membershipProtocol;
    protected final ManagedClusterMembershipService membershipService;
    protected final ManagedClusterCommunicationService communicationService;
    protected final ManagedClusterEventService eventService;
    protected volatile CompletableFuture<Void> openFuture;
    protected volatile CompletableFuture<Void> closeFuture;
    protected final ThreadContext threadContext = new SingleThreadContext("atomix-cluster-%d");
    private final AtomicBoolean started = new AtomicBoolean();

    public AtomixCluster(ClusterConfig config, Version version) {
        this(config, version, AtomixCluster.buildMessagingService(config), AtomixCluster.buildUnicastService(config));
    }

    protected AtomixCluster(ClusterConfig config, Version version, ManagedMessagingService messagingService, ManagedUnicastService unicastService) {
        this.messagingService = messagingService != null ? messagingService : AtomixCluster.buildMessagingService(config);
        this.unicastService = unicastService != null ? unicastService : AtomixCluster.buildUnicastService(config);
        this.discoveryProvider = AtomixCluster.buildLocationProvider(config);
        this.membershipProtocol = AtomixCluster.buildMembershipProtocol(config);
        this.membershipService = AtomixCluster.buildClusterMembershipService(config, this, this.discoveryProvider, this.membershipProtocol, version);
        this.communicationService = AtomixCluster.buildClusterMessagingService(this.getMembershipService(), this.getMessagingService(), this.getUnicastService());
        this.eventService = AtomixCluster.buildClusterEventService(this.getMembershipService(), this.getMessagingService());
    }

    public static AtomixClusterBuilder builder() {
        return AtomixCluster.builder(new ClusterConfig());
    }

    public static AtomixClusterBuilder builder(ClusterConfig config) {
        return new AtomixClusterBuilder(config);
    }

    @Override
    public MessagingService getMessagingService() {
        return this.messagingService;
    }

    @Override
    public UnicastService getUnicastService() {
        return this.unicastService;
    }

    public ClusterMembershipService getMembershipService() {
        return this.membershipService;
    }

    public ClusterCommunicationService getCommunicationService() {
        return this.communicationService;
    }

    public ClusterEventService getEventService() {
        return this.eventService;
    }

    public synchronized CompletableFuture<Void> start() {
        if (this.closeFuture != null) {
            return CompletableFuture.failedFuture(new IllegalStateException("Cluster instance is " + (this.closeFuture.isDone() ? "shutdown" : "shutting down")));
        }
        if (this.openFuture != null) {
            return this.openFuture;
        }
        this.openFuture = this.startServices().thenComposeAsync(v -> this.completeStartup(), (Executor)this.threadContext);
        return this.openFuture;
    }

    public boolean isRunning() {
        return this.started.get();
    }

    public synchronized CompletableFuture<Void> stop() {
        if (this.closeFuture != null) {
            return this.closeFuture;
        }
        this.closeFuture = this.stopServices().thenComposeAsync(v -> this.completeShutdown(), (Executor)this.threadContext);
        return this.closeFuture;
    }

    protected CompletableFuture<Void> startServices() {
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.messagingService.start().thenComposeAsync(v -> this.unicastService.start(), (Executor)this.threadContext)).thenComposeAsync(v -> this.membershipService.start(), (Executor)this.threadContext)).thenComposeAsync(v -> this.communicationService.start(), (Executor)this.threadContext)).thenComposeAsync(v -> this.eventService.start(), (Executor)this.threadContext)).thenApply(v -> null);
    }

    protected CompletableFuture<Void> completeStartup() {
        this.started.set(true);
        return CompletableFuture.completedFuture(null);
    }

    private Void logServiceStopError(String serviceName, Throwable throwable) {
        LOGGER.error("Failed to stop service {}", (Object)serviceName, (Object)throwable);
        return null;
    }

    protected CompletableFuture<Void> stopServices() {
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.communicationService.stop().exceptionally(e -> this.logServiceStopError("communicationService", (Throwable)e))).thenComposeAsync(v -> this.eventService.stop(), (Executor)this.threadContext)).exceptionally(e -> this.logServiceStopError("eventService", (Throwable)e))).thenComposeAsync(v -> this.membershipService.stop(), (Executor)this.threadContext)).exceptionally(e -> this.logServiceStopError("membershipService", (Throwable)e))).thenComposeAsync(v -> this.unicastService.stop(), (Executor)this.threadContext)).exceptionally(e -> this.logServiceStopError("unicastService", (Throwable)e))).thenComposeAsync(v -> this.messagingService.stop(), (Executor)this.threadContext)).exceptionally(e -> this.logServiceStopError("messagingService", (Throwable)e));
    }

    protected CompletableFuture<Void> completeShutdown() {
        this.threadContext.close();
        this.started.set(false);
        LOGGER.info("Stopped");
        return CompletableFuture.completedFuture(null);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).toString();
    }

    protected static ManagedMessagingService buildMessagingService(ClusterConfig config) {
        return new NettyMessagingService(config.getClusterId(), config.getNodeConfig().getAddress(), config.getMessagingConfig());
    }

    protected static ManagedUnicastService buildUnicastService(ClusterConfig config) {
        return new NettyUnicastService(config.getClusterId(), config.getNodeConfig().getAddress(), config.getMessagingConfig());
    }

    protected static NodeDiscoveryProvider buildLocationProvider(ClusterConfig config) {
        NodeDiscoveryConfig discoveryProviderConfig = config.getDiscoveryConfig();
        if (discoveryProviderConfig != null) {
            return ((NodeDiscoveryProvider.Type)discoveryProviderConfig.getType()).newProvider(discoveryProviderConfig);
        }
        return new BootstrapDiscoveryProvider(Collections.emptyList());
    }

    protected static GroupMembershipProtocol buildMembershipProtocol(ClusterConfig config) {
        return ((GroupMembershipProtocol.Type)config.getProtocolConfig().getType()).newProtocol(config.getProtocolConfig());
    }

    protected static ManagedClusterMembershipService buildClusterMembershipService(ClusterConfig config, BootstrapService bootstrapService, NodeDiscoveryProvider discoveryProvider, GroupMembershipProtocol membershipProtocol, Version version) {
        Member localMember = Member.builder().withId(config.getNodeConfig().getId()).withAddress(config.getNodeConfig().getAddress()).withHostId(config.getNodeConfig().getHostId()).withRackId(config.getNodeConfig().getRackId()).withZoneId(config.getNodeConfig().getZoneId()).withProperties(config.getNodeConfig().getProperties()).build();
        return new DefaultClusterMembershipService(localMember, version, new DefaultNodeDiscoveryService(bootstrapService, localMember, discoveryProvider), bootstrapService, membershipProtocol);
    }

    protected static ManagedClusterCommunicationService buildClusterMessagingService(ClusterMembershipService membershipService, MessagingService messagingService, UnicastService unicastService) {
        return new DefaultClusterCommunicationService(membershipService, messagingService, unicastService);
    }

    protected static ManagedClusterEventService buildClusterEventService(ClusterMembershipService membershipService, MessagingService messagingService) {
        return new DefaultClusterEventService(membershipService, messagingService);
    }
}

