/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.roles;

import io.atomix.raft.RaftError;
import io.atomix.raft.RaftServer;
import io.atomix.raft.impl.RaftContext;
import io.atomix.raft.protocol.AppendRequest;
import io.atomix.raft.protocol.AppendResponse;
import io.atomix.raft.protocol.ConfigureRequest;
import io.atomix.raft.protocol.ConfigureResponse;
import io.atomix.raft.protocol.InstallRequest;
import io.atomix.raft.protocol.InstallResponse;
import io.atomix.raft.protocol.PollRequest;
import io.atomix.raft.protocol.PollResponse;
import io.atomix.raft.protocol.RaftResponse;
import io.atomix.raft.protocol.ReconfigureRequest;
import io.atomix.raft.protocol.ReconfigureResponse;
import io.atomix.raft.protocol.TransferRequest;
import io.atomix.raft.protocol.TransferResponse;
import io.atomix.raft.protocol.VoteRequest;
import io.atomix.raft.protocol.VoteResponse;
import io.atomix.raft.roles.AbstractRole;
import io.atomix.raft.storage.system.Configuration;
import java.util.concurrent.CompletableFuture;

public class InactiveRole
extends AbstractRole {
    public InactiveRole(RaftContext context) {
        super(context);
    }

    @Override
    public RaftServer.Role role() {
        return RaftServer.Role.INACTIVE;
    }

    @Override
    public CompletableFuture<ConfigureResponse> onConfigure(ConfigureRequest request) {
        this.raft.checkThread();
        this.logRequest(request);
        this.updateTermAndLeader(request.term(), request.leader());
        Configuration configuration = new Configuration(request.index(), request.term(), request.timestamp(), request.members());
        this.raft.getCluster().configure(configuration);
        if (this.raft.getCommitIndex() >= this.raft.getCluster().getConfiguration().index()) {
            this.raft.getCluster().commit();
        }
        return CompletableFuture.completedFuture(this.logResponse(((ConfigureResponse.Builder)ConfigureResponse.builder().withStatus(RaftResponse.Status.OK)).build()));
    }

    @Override
    public CompletableFuture<InstallResponse> onInstall(InstallRequest request) {
        this.logRequest(request);
        InstallResponse result = this.logResponse(((InstallResponse.Builder)((InstallResponse.Builder)InstallResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.UNAVAILABLE)).build());
        return CompletableFuture.completedFuture(result);
    }

    @Override
    public CompletableFuture<ReconfigureResponse> onReconfigure(ReconfigureRequest request) {
        this.logRequest(request);
        ReconfigureResponse result = this.logResponse(((ReconfigureResponse.Builder)((ReconfigureResponse.Builder)ReconfigureResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.UNAVAILABLE)).build());
        return CompletableFuture.completedFuture(result);
    }

    @Override
    public CompletableFuture<TransferResponse> onTransfer(TransferRequest request) {
        this.logRequest(request);
        TransferResponse result = this.logResponse(((TransferResponse.Builder)((TransferResponse.Builder)TransferResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.UNAVAILABLE)).build());
        return CompletableFuture.completedFuture(result);
    }

    @Override
    public CompletableFuture<AppendResponse> onAppend(AppendRequest request) {
        this.logRequest(request);
        AppendResponse result = this.logResponse(((AppendResponse.Builder)((AppendResponse.Builder)AppendResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.UNAVAILABLE)).build());
        return CompletableFuture.completedFuture(result);
    }

    @Override
    public CompletableFuture<PollResponse> onPoll(PollRequest request) {
        this.logRequest(request);
        PollResponse result = this.logResponse(((PollResponse.Builder)((PollResponse.Builder)PollResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.UNAVAILABLE)).build());
        return CompletableFuture.completedFuture(result);
    }

    @Override
    public CompletableFuture<VoteResponse> onVote(VoteRequest request) {
        this.logRequest(request);
        VoteResponse result = this.logResponse(((VoteResponse.Builder)((VoteResponse.Builder)VoteResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.UNAVAILABLE)).build());
        return CompletableFuture.completedFuture(result);
    }
}

