/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.storage.serializer;

import io.atomix.raft.storage.serializer.EntryType;
import io.atomix.raft.storage.serializer.MessageHeaderEncoder;
import io.atomix.raft.storage.serializer.MetaAttribute;
import io.atomix.raft.storage.serializer.RaftLogEntryDecoder;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.sbe.MessageEncoderFlyweight;

public final class RaftLogEntryEncoder
implements MessageEncoderFlyweight {
    public static final int BLOCK_LENGTH = 9;
    public static final int TEMPLATE_ID = 1;
    public static final int SCHEMA_ID = 8;
    public static final int SCHEMA_VERSION = 1;
    public static final String SEMANTIC_VERSION = "0.1.0";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final RaftLogEntryEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;

    public int sbeBlockLength() {
        return 9;
    }

    public int sbeTemplateId() {
        return 1;
    }

    public int sbeSchemaId() {
        return 8;
    }

    public int sbeSchemaVersion() {
        return 1;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public RaftLogEntryEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.limit(offset + 9);
        return this;
    }

    public RaftLogEntryEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(9).templateId(1).schemaId(8).version(1);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int termId() {
        return 0;
    }

    public static int termSinceVersion() {
        return 0;
    }

    public static int termEncodingOffset() {
        return 0;
    }

    public static int termEncodingLength() {
        return 8;
    }

    public static String termMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long termNullValue() {
        return -1L;
    }

    public static long termMinValue() {
        return 0L;
    }

    public static long termMaxValue() {
        return -2L;
    }

    public RaftLogEntryEncoder term(long value) {
        this.buffer.putLong(this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int typeId() {
        return 1;
    }

    public static int typeSinceVersion() {
        return 0;
    }

    public static int typeEncodingOffset() {
        return 8;
    }

    public static int typeEncodingLength() {
        return 1;
    }

    public static String typeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public RaftLogEntryEncoder type(EntryType value) {
        this.buffer.putByte(this.offset + 8, (byte)value.value());
        return this;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        RaftLogEntryDecoder decoder = new RaftLogEntryDecoder();
        decoder.wrap((DirectBuffer)this.buffer, this.initialOffset, 9, 1);
        return decoder.appendTo(builder);
    }
}

