/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.client.mgmt;

import com.auth0.client.mgmt.BaseManagementEntity;
import com.auth0.client.mgmt.filter.ActionsFilter;
import com.auth0.client.mgmt.filter.BaseFilter;
import com.auth0.client.mgmt.filter.PageFilter;
import com.auth0.json.mgmt.actions.Action;
import com.auth0.json.mgmt.actions.ActionsPage;
import com.auth0.json.mgmt.actions.BindingsPage;
import com.auth0.json.mgmt.actions.BindingsUpdateRequest;
import com.auth0.json.mgmt.actions.Execution;
import com.auth0.json.mgmt.actions.Triggers;
import com.auth0.json.mgmt.actions.Version;
import com.auth0.json.mgmt.actions.VersionsPage;
import com.auth0.net.CustomRequest;
import com.auth0.net.EmptyBodyRequest;
import com.auth0.net.Request;
import com.auth0.net.VoidRequest;
import com.auth0.utils.Asserts;
import com.fasterxml.jackson.core.type.TypeReference;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;

public class ActionsEntity
extends BaseManagementEntity {
    private static final String ACTIONS_BASE_PATH = "api/v2/actions";
    private static final String ACTIONS_PATH = "actions";
    private static final String TRIGGERS_PATH = "triggers";
    private static final String DEPLOY_PATH = "deploy";
    private static final String VERSIONS_PATH = "versions";
    private static final String EXECUTIONS_PATH = "executions";
    private static final String BINDINGS_PATH = "bindings";
    private static final String AUTHORIZATION_HEADER = "Authorization";

    ActionsEntity(OkHttpClient client, HttpUrl baseUrl, String apiToken) {
        super(client, baseUrl, apiToken);
    }

    public Request<Action> create(Action action) {
        Asserts.assertNotNull(action, "action");
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments(ACTIONS_BASE_PATH).addPathSegment(ACTIONS_PATH);
        String url = builder.build().toString();
        CustomRequest<Action> request = new CustomRequest<Action>(this.client, url, "POST", new TypeReference<Action>(){});
        request.addHeader(AUTHORIZATION_HEADER, "Bearer " + this.apiToken);
        request.setBody(action);
        return request;
    }

    public Request<Action> get(String actionId) {
        Asserts.assertNotNull(actionId, "action ID");
        String url = this.baseUrl.newBuilder().addPathSegments(ACTIONS_BASE_PATH).addPathSegment(ACTIONS_PATH).addPathSegment(actionId).build().toString();
        CustomRequest<Action> request = new CustomRequest<Action>(this.client, url, "GET", new TypeReference<Action>(){});
        request.addHeader(AUTHORIZATION_HEADER, "Bearer " + this.apiToken);
        return request;
    }

    public Request<Void> delete(String actionId) {
        return this.delete(actionId, false);
    }

    public Request<Void> delete(String actionId, boolean force) {
        Asserts.assertNotNull(actionId, "action ID");
        String url = this.baseUrl.newBuilder().addPathSegments(ACTIONS_BASE_PATH).addPathSegment(ACTIONS_PATH).addPathSegment(actionId).addQueryParameter("force", String.valueOf(force)).build().toString();
        VoidRequest voidRequest = new VoidRequest(this.client, url, "DELETE");
        voidRequest.addHeader(AUTHORIZATION_HEADER, "Bearer " + this.apiToken);
        return voidRequest;
    }

    public Request<Triggers> getTriggers() {
        String url = this.baseUrl.newBuilder().addPathSegments(ACTIONS_BASE_PATH).addPathSegment(TRIGGERS_PATH).build().toString();
        CustomRequest<Triggers> request = new CustomRequest<Triggers>(this.client, url, "GET", new TypeReference<Triggers>(){});
        request.addHeader(AUTHORIZATION_HEADER, "Bearer " + this.apiToken);
        return request;
    }

    public Request<Action> update(String actionId, Action action) {
        Asserts.assertNotNull(actionId, "action ID");
        Asserts.assertNotNull(action, "action");
        String url = this.baseUrl.newBuilder().addPathSegments(ACTIONS_BASE_PATH).addPathSegment(ACTIONS_PATH).addPathSegment(actionId).build().toString();
        CustomRequest<Action> request = new CustomRequest<Action>(this.client, url, "PATCH", new TypeReference<Action>(){});
        request.setBody(action);
        request.addHeader(AUTHORIZATION_HEADER, "Bearer " + this.apiToken);
        return request;
    }

    public Request<Version> deploy(String actionId) {
        Asserts.assertNotNull(actionId, "action ID");
        String url = this.baseUrl.newBuilder().addPathSegments(ACTIONS_BASE_PATH).addPathSegment(ACTIONS_PATH).addPathSegment(actionId).addPathSegment(DEPLOY_PATH).build().toString();
        EmptyBodyRequest<Version> request = new EmptyBodyRequest<Version>(this.client, url, "POST", new TypeReference<Version>(){});
        request.addHeader(AUTHORIZATION_HEADER, "Bearer " + this.apiToken);
        return request;
    }

    public Request<Version> getVersion(String actionId, String actionVersionId) {
        Asserts.assertNotNull(actionId, "action ID");
        Asserts.assertNotNull(actionVersionId, "action version ID");
        String url = this.baseUrl.newBuilder().addPathSegments(ACTIONS_BASE_PATH).addPathSegment(ACTIONS_PATH).addPathSegment(actionId).addPathSegment(VERSIONS_PATH).addPathSegment(actionVersionId).build().toString();
        CustomRequest<Version> request = new CustomRequest<Version>(this.client, url, "GET", new TypeReference<Version>(){});
        request.addHeader(AUTHORIZATION_HEADER, "Bearer " + this.apiToken);
        return request;
    }

    public Request<Version> rollBackToVersion(String actionId, String actionVersionId) {
        Asserts.assertNotNull(actionId, "action ID");
        Asserts.assertNotNull(actionVersionId, "action version ID");
        String url = this.baseUrl.newBuilder().addPathSegments(ACTIONS_BASE_PATH).addPathSegment(ACTIONS_PATH).addPathSegment(actionId).addPathSegment(VERSIONS_PATH).addPathSegment(actionVersionId).addPathSegment(DEPLOY_PATH).build().toString();
        EmptyObjectRequest<Version> request = new EmptyObjectRequest<Version>(this.client, url, "POST", new TypeReference<Version>(){});
        request.addHeader(AUTHORIZATION_HEADER, "Bearer " + this.apiToken);
        return request;
    }

    public Request<Execution> getExecution(String executionId) {
        Asserts.assertNotNull(executionId, "execution ID");
        String url = this.baseUrl.newBuilder().addPathSegments(ACTIONS_BASE_PATH).addPathSegment(EXECUTIONS_PATH).addPathSegment(executionId).build().toString();
        CustomRequest<Execution> request = new CustomRequest<Execution>(this.client, url, "GET", new TypeReference<Execution>(){});
        request.addHeader(AUTHORIZATION_HEADER, "Bearer " + this.apiToken);
        return request;
    }

    public Request<ActionsPage> list(ActionsFilter filter) {
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments(ACTIONS_BASE_PATH).addPathSegment(ACTIONS_PATH);
        this.applyFilter(filter, builder);
        String url = builder.build().toString();
        CustomRequest<ActionsPage> request = new CustomRequest<ActionsPage>(this.client, url, "GET", new TypeReference<ActionsPage>(){});
        request.addHeader(AUTHORIZATION_HEADER, "Bearer " + this.apiToken);
        return request;
    }

    public Request<VersionsPage> getVersions(String actionId, PageFilter filter) {
        Asserts.assertNotNull(actionId, "action ID");
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments(ACTIONS_BASE_PATH).addPathSegment(ACTIONS_PATH).addPathSegment(actionId).addPathSegment(VERSIONS_PATH);
        this.applyFilter(filter, builder);
        String url = builder.build().toString();
        CustomRequest<VersionsPage> request = new CustomRequest<VersionsPage>(this.client, url, "GET", new TypeReference<VersionsPage>(){});
        request.addHeader(AUTHORIZATION_HEADER, "Bearer " + this.apiToken);
        return request;
    }

    public Request<BindingsPage> getTriggerBindings(String triggerId, PageFilter filter) {
        Asserts.assertNotNull(triggerId, "trigger ID");
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments(ACTIONS_BASE_PATH).addPathSegment(TRIGGERS_PATH).addPathSegment(triggerId).addPathSegment(BINDINGS_PATH);
        this.applyFilter(filter, builder);
        String url = builder.build().toString();
        CustomRequest<BindingsPage> request = new CustomRequest<BindingsPage>(this.client, url, "GET", new TypeReference<BindingsPage>(){});
        request.addHeader(AUTHORIZATION_HEADER, "Bearer " + this.apiToken);
        return request;
    }

    public Request<BindingsPage> updateTriggerBindings(String triggerId, BindingsUpdateRequest bindingsUpdateRequest) {
        Asserts.assertNotNull(triggerId, "trigger ID");
        Asserts.assertNotNull(bindingsUpdateRequest, "request body");
        String url = this.baseUrl.newBuilder().addPathSegments(ACTIONS_BASE_PATH).addPathSegment(TRIGGERS_PATH).addPathSegment(triggerId).addPathSegment(BINDINGS_PATH).build().toString();
        CustomRequest<BindingsPage> request = new CustomRequest<BindingsPage>(this.client, url, "PATCH", new TypeReference<BindingsPage>(){});
        request.setBody(bindingsUpdateRequest);
        request.addHeader(AUTHORIZATION_HEADER, "Bearer " + this.apiToken);
        return request;
    }

    private void applyFilter(BaseFilter filter, HttpUrl.Builder builder) {
        if (filter != null) {
            filter.getAsMap().forEach((k, v) -> builder.addQueryParameter(k, String.valueOf(v)));
        }
    }

    private static class EmptyObjectRequest<T>
    extends EmptyBodyRequest<T> {
        EmptyObjectRequest(OkHttpClient client, String url, String method, TypeReference<T> tType) {
            super(client, url, method, tType);
        }

        @Override
        protected RequestBody createRequestBody() {
            return RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (byte[])"{}".getBytes());
        }
    }
}

