/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.client.mgmt;

import com.auth0.client.mgmt.BaseManagementEntity;
import com.auth0.client.mgmt.filter.GrantsFilter;
import com.auth0.json.mgmt.Grant;
import com.auth0.json.mgmt.GrantsPage;
import com.auth0.net.CustomRequest;
import com.auth0.net.Request;
import com.auth0.net.VoidRequest;
import com.auth0.utils.Asserts;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import java.util.Map;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;

public class GrantsEntity
extends BaseManagementEntity {
    GrantsEntity(OkHttpClient client, HttpUrl baseUrl, String apiToken) {
        super(client, baseUrl, apiToken);
    }

    public Request<GrantsPage> list(String userId, GrantsFilter filter) {
        Asserts.assertNotNull(userId, "user id");
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments("api/v2/grants").addQueryParameter("user_id", userId);
        if (filter != null) {
            for (Map.Entry<String, Object> e : filter.getAsMap().entrySet()) {
                builder.addQueryParameter(e.getKey(), String.valueOf(e.getValue()));
            }
        }
        String url = builder.build().toString();
        CustomRequest<GrantsPage> request = new CustomRequest<GrantsPage>(this.client, url, "GET", new TypeReference<GrantsPage>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }

    @Deprecated
    public Request<List<Grant>> list(String userId) {
        Asserts.assertNotNull(userId, "user id");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/grants").addQueryParameter("user_id", userId).build().toString();
        CustomRequest<List<Grant>> request = new CustomRequest<List<Grant>>(this.client, url, "GET", new TypeReference<List<Grant>>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }

    public Request<Void> delete(String grantId) {
        Asserts.assertNotNull(grantId, "grant id");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/grants").addPathSegment(grantId).build().toString();
        VoidRequest request = new VoidRequest(this.client, url, "DELETE");
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }

    public Request<Void> deleteAll(String userId) {
        Asserts.assertNotNull(userId, "user id");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/grants").addQueryParameter("user_id", userId).build().toString();
        VoidRequest request = new VoidRequest(this.client, url, "DELETE");
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }
}

