/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.exception;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class PasswordStrengthErrorParser {
    private static final String RULE_TYPE_LENGTH_AT_LEAST = "lengthAtLeast";
    private static final String RULE_TYPE_CONTAINS_AT_LEAST = "containsAtLeast";
    private static final String RULE_TYPE_SHOULD_CONTAIN = "shouldContain";
    private static final String RULE_TYPE_IDENTICAL_CHARS = "identicalChars";
    private static final String KEY_RULES = "rules";
    private static final String KEY_CODE = "code";
    private static final String KEY_VERIFIED = "verified";
    private static final String KEY_FORMAT = "format";
    private static final String KEY_ITEMS = "items";
    private static final String KEY_MESSAGE = "message";
    private String description;

    PasswordStrengthErrorParser(Map<String, Object> descriptionMap) {
        List rules = (List)descriptionMap.get(KEY_RULES);
        this.parseRules(rules);
    }

    public String getDescription() {
        return this.description;
    }

    private void parseRules(List<Map<String, Object>> rules) {
        ArrayList<String> items = new ArrayList<String>();
        for (Map<String, Object> rule : rules) {
            String code;
            boolean isVerified = (Boolean)rule.get(KEY_VERIFIED);
            if (isVerified) continue;
            switch (code = (String)rule.get(KEY_CODE)) {
                case "lengthAtLeast": {
                    items.add(this.asLengthAtLeast(rule));
                    break;
                }
                case "identicalChars": {
                    items.add(this.asIdenticalChars(rule));
                    break;
                }
                case "containsAtLeast": 
                case "shouldContain": {
                    items.add(this.asContainsCharset(rule));
                }
            }
        }
        this.description = this.joinStrings("; ", items);
    }

    private String asLengthAtLeast(Map<String, Object> rule) {
        List length = (List)rule.get(KEY_FORMAT);
        String message = (String)rule.get(KEY_MESSAGE);
        return String.format(message, ((Number)length.get(0)).intValue());
    }

    private String asContainsCharset(Map<String, Object> rule) {
        List itemsList = (List)rule.get(KEY_ITEMS);
        ArrayList<String> items = new ArrayList<String>();
        for (Map i : itemsList) {
            items.add((String)i.get(KEY_MESSAGE));
        }
        String requiredItems = this.joinStrings(", ", items);
        String message = (String)rule.get(KEY_MESSAGE);
        if (rule.containsKey(KEY_FORMAT)) {
            List quantity = (List)rule.get(KEY_FORMAT);
            message = String.format(message, ((Number)quantity.get(0)).intValue(), ((Number)quantity.get(1)).intValue());
        }
        return String.format("%s %s", message, requiredItems);
    }

    private String asIdenticalChars(Map<String, Object> rule) {
        List example = (List)rule.get(KEY_FORMAT);
        Number count = (Number)example.get(0);
        String message = (String)rule.get(KEY_MESSAGE);
        return String.format(message, count.intValue(), example.get(1));
    }

    private String joinStrings(String delimiter, List<String> items) {
        int i;
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < items.size() - 1; ++i) {
            sb.append(items.get(i)).append(delimiter);
        }
        sb.append(items.get(i));
        return sb.toString();
    }
}

