/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.metrics;

import io.prometheus.client.Counter;

public final class JobMetrics {
    private static final Counter JOB_EVENTS = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().namespace("zeebe")).name("job_events_total")).help("Number of job events")).labelNames(new String[]{"action", "partition", "type"})).register();
    private final String partitionIdLabel;

    public JobMetrics(int partitionId) {
        this.partitionIdLabel = String.valueOf(partitionId);
    }

    private void jobEvent(String action, String type) {
        ((Counter.Child)JOB_EVENTS.labels(new String[]{action, this.partitionIdLabel, type})).inc();
    }

    public void jobCreated(String type) {
        this.jobEvent("created", type);
    }

    public void jobActivated(String type, int activatedJobs) {
        ((Counter.Child)JOB_EVENTS.labels(new String[]{"activated", this.partitionIdLabel, type})).inc((double)activatedJobs);
    }

    public void jobTimedOut(String type) {
        this.jobEvent("timed out", type);
    }

    public void jobCompleted(String type) {
        this.jobEvent("completed", type);
    }

    public void jobFailed(String type) {
        this.jobEvent("failed", type);
    }

    public void jobCanceled(String type) {
        this.jobEvent("canceled", type);
    }

    public void jobErrorThrown(String type) {
        this.jobEvent("error thrown", type);
    }

    static void clear() {
        JOB_EVENTS.clear();
    }
}

