/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.behavior;

import io.camunda.zeebe.el.ExpressionLanguageFactory;
import io.camunda.zeebe.engine.metrics.JobMetrics;
import io.camunda.zeebe.engine.processing.bpmn.ProcessInstanceStateTransitionGuard;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBufferedMessageStartEventBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnDecisionBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnEventPublicationBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnEventSubscriptionBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnIncidentBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnJobActivationBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnJobBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnProcessResultSenderBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnSignalBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnVariableMappingBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.MultiInstanceOutputCollectionBehavior;
import io.camunda.zeebe.engine.processing.common.CatchEventBehavior;
import io.camunda.zeebe.engine.processing.common.DecisionBehavior;
import io.camunda.zeebe.engine.processing.common.ElementActivationBehavior;
import io.camunda.zeebe.engine.processing.common.EventTriggerBehavior;
import io.camunda.zeebe.engine.processing.common.ExpressionProcessor;
import io.camunda.zeebe.engine.processing.message.command.SubscriptionCommandSender;
import io.camunda.zeebe.engine.processing.streamprocessor.JobStreamer;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.processing.timer.DueDateTimerChecker;
import io.camunda.zeebe.engine.processing.variable.VariableBehavior;
import io.camunda.zeebe.engine.processing.variable.VariableStateEvaluationContextLookup;
import io.camunda.zeebe.engine.state.mutable.MutableProcessingState;

public final class BpmnBehaviorsImpl
implements BpmnBehaviors {
    private final ExpressionProcessor expressionBehavior;
    private final BpmnDecisionBehavior bpmnDecisionBehavior;
    private final BpmnVariableMappingBehavior variableMappingBehavior;
    private final BpmnEventPublicationBehavior eventPublicationBehavior;
    private final BpmnEventSubscriptionBehavior eventSubscriptionBehavior;
    private final BpmnIncidentBehavior incidentBehavior;
    private final BpmnStateBehavior stateBehavior;
    private final ProcessInstanceStateTransitionGuard stateTransitionGuard;
    private final BpmnProcessResultSenderBehavior processResultSenderBehavior;
    private final BpmnBufferedMessageStartEventBehavior bufferedMessageStartEventBehavior;
    private final BpmnJobBehavior jobBehavior;
    private final MultiInstanceOutputCollectionBehavior multiInstanceOutputCollectionBehavior;
    private final CatchEventBehavior catchEventBehavior;
    private final EventTriggerBehavior eventTriggerBehavior;
    private final VariableBehavior variableBehavior;
    private final ElementActivationBehavior elementActivationBehavior;
    private final BpmnJobActivationBehavior jobActivationBehavior;
    private final BpmnSignalBehavior signalBehavior;

    public BpmnBehaviorsImpl(MutableProcessingState processingState, Writers writers, JobMetrics jobMetrics, DecisionBehavior decisionBehavior, SubscriptionCommandSender subscriptionCommandSender, int partitionsCount, DueDateTimerChecker timerChecker, JobStreamer jobStreamer) {
        this.expressionBehavior = new ExpressionProcessor(ExpressionLanguageFactory.createExpressionLanguage(), new VariableStateEvaluationContextLookup(processingState.getVariableState()));
        this.variableBehavior = new VariableBehavior(processingState.getVariableState(), writers.state(), processingState.getKeyGenerator());
        this.catchEventBehavior = new CatchEventBehavior(processingState, processingState.getKeyGenerator(), this.expressionBehavior, subscriptionCommandSender, writers.state(), writers.sideEffect(), timerChecker, partitionsCount);
        this.eventTriggerBehavior = new EventTriggerBehavior(processingState.getKeyGenerator(), this.catchEventBehavior, writers, processingState);
        this.bpmnDecisionBehavior = new BpmnDecisionBehavior(decisionBehavior, processingState, this.eventTriggerBehavior, writers.state(), processingState.getKeyGenerator(), this.expressionBehavior);
        this.stateBehavior = new BpmnStateBehavior(processingState, this.variableBehavior);
        this.stateTransitionGuard = new ProcessInstanceStateTransitionGuard(this.stateBehavior);
        this.variableMappingBehavior = new BpmnVariableMappingBehavior(this.expressionBehavior, processingState, this.variableBehavior);
        this.eventSubscriptionBehavior = new BpmnEventSubscriptionBehavior(this.catchEventBehavior, this.eventTriggerBehavior, processingState);
        this.incidentBehavior = new BpmnIncidentBehavior(processingState, processingState.getKeyGenerator(), writers.state());
        this.eventPublicationBehavior = new BpmnEventPublicationBehavior(processingState, processingState.getKeyGenerator(), this.eventTriggerBehavior, this.stateBehavior, writers);
        this.processResultSenderBehavior = new BpmnProcessResultSenderBehavior(processingState, writers.response());
        this.bufferedMessageStartEventBehavior = new BpmnBufferedMessageStartEventBehavior(processingState, processingState.getKeyGenerator(), this.eventTriggerBehavior, this.stateBehavior, writers);
        this.jobActivationBehavior = new BpmnJobActivationBehavior(jobStreamer, processingState.getVariableState(), writers, jobMetrics);
        this.jobBehavior = new BpmnJobBehavior(processingState.getKeyGenerator(), processingState.getJobState(), writers, this.expressionBehavior, this.stateBehavior, this.incidentBehavior, this.jobActivationBehavior, jobMetrics);
        this.multiInstanceOutputCollectionBehavior = new MultiInstanceOutputCollectionBehavior(this.stateBehavior, this.expressionBehavior());
        this.elementActivationBehavior = new ElementActivationBehavior(processingState.getKeyGenerator(), writers, this.catchEventBehavior, processingState.getElementInstanceState());
        this.signalBehavior = new BpmnSignalBehavior(processingState.getKeyGenerator(), processingState.getVariableState(), writers, this.expressionBehavior);
    }

    @Override
    public ExpressionProcessor expressionBehavior() {
        return this.expressionBehavior;
    }

    @Override
    public BpmnDecisionBehavior bpmnDecisionBehavior() {
        return this.bpmnDecisionBehavior;
    }

    @Override
    public BpmnVariableMappingBehavior variableMappingBehavior() {
        return this.variableMappingBehavior;
    }

    @Override
    public BpmnEventPublicationBehavior eventPublicationBehavior() {
        return this.eventPublicationBehavior;
    }

    @Override
    public BpmnEventSubscriptionBehavior eventSubscriptionBehavior() {
        return this.eventSubscriptionBehavior;
    }

    @Override
    public BpmnIncidentBehavior incidentBehavior() {
        return this.incidentBehavior;
    }

    @Override
    public BpmnStateBehavior stateBehavior() {
        return this.stateBehavior;
    }

    @Override
    public ProcessInstanceStateTransitionGuard stateTransitionGuard() {
        return this.stateTransitionGuard;
    }

    @Override
    public BpmnProcessResultSenderBehavior processResultSenderBehavior() {
        return this.processResultSenderBehavior;
    }

    @Override
    public BpmnBufferedMessageStartEventBehavior bufferedMessageStartEventBehavior() {
        return this.bufferedMessageStartEventBehavior;
    }

    @Override
    public BpmnJobBehavior jobBehavior() {
        return this.jobBehavior;
    }

    @Override
    public BpmnSignalBehavior signalBehavior() {
        return this.signalBehavior;
    }

    @Override
    public MultiInstanceOutputCollectionBehavior outputCollectionBehavior() {
        return this.multiInstanceOutputCollectionBehavior;
    }

    @Override
    public CatchEventBehavior catchEventBehavior() {
        return this.catchEventBehavior;
    }

    @Override
    public EventTriggerBehavior eventTriggerBehavior() {
        return this.eventTriggerBehavior;
    }

    @Override
    public VariableBehavior variableBehavior() {
        return this.variableBehavior;
    }

    @Override
    public ElementActivationBehavior elementActivationBehavior() {
        return this.elementActivationBehavior;
    }

    @Override
    public BpmnJobActivationBehavior jobActivationBehavior() {
        return this.jobActivationBehavior;
    }
}

