/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.behavior;

import io.camunda.zeebe.engine.metrics.JobMetrics;
import io.camunda.zeebe.engine.processing.streamprocessor.JobStreamer;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.SideEffectWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.immutable.VariableState;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;

public class BpmnJobActivationBehavior {
    private final JobStreamer jobStreamer;
    private final VariableState variableState;
    private final StateWriter stateWriter;
    private final SideEffectWriter sideEffectWriter;
    private final JobMetrics jobMetrics;

    public BpmnJobActivationBehavior(JobStreamer jobStreamer, VariableState variableState, Writers writers, JobMetrics jobMetrics) {
        this.jobStreamer = jobStreamer;
        this.variableState = variableState;
        this.stateWriter = writers.state();
        this.sideEffectWriter = writers.sideEffect();
        this.jobMetrics = jobMetrics;
    }

    public void publishWork(JobRecord jobRecord) {
        String jobType = jobRecord.getType();
        this.sideEffectWriter.appendSideEffect(() -> {
            this.jobStreamer.notifyWorkAvailable(jobType);
            return true;
        });
    }
}

