/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.distribute;

import io.camunda.zeebe.engine.processing.deployment.StartEventSubscriptionManager;
import io.camunda.zeebe.engine.processing.deployment.distribute.DeploymentDistributionCommandSender;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.immutable.ProcessingState;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.intent.DeploymentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.stream.api.records.TypedRecord;
import io.camunda.zeebe.stream.api.state.KeyGenerator;

public final class DeploymentDistributeProcessor
implements TypedRecordProcessor<DeploymentRecord> {
    private final StartEventSubscriptionManager startEventSubscriptionManager;
    private final StateWriter stateWriter;
    private final DeploymentDistributionCommandSender deploymentDistributionCommandSender;

    public DeploymentDistributeProcessor(ProcessingState processingState, DeploymentDistributionCommandSender deploymentDistributionCommandSender, Writers writers, KeyGenerator keyGenerator) {
        this.deploymentDistributionCommandSender = deploymentDistributionCommandSender;
        this.startEventSubscriptionManager = new StartEventSubscriptionManager(processingState, keyGenerator);
        this.stateWriter = writers.state();
    }

    @Override
    public void processRecord(TypedRecord<DeploymentRecord> event) {
        DeploymentRecord deploymentEvent = (DeploymentRecord)event.getValue();
        long deploymentKey = event.getKey();
        this.stateWriter.appendFollowUpEvent(deploymentKey, (Intent)DeploymentIntent.DISTRIBUTED, (RecordValue)deploymentEvent);
        this.deploymentDistributionCommandSender.completeOnPartition(deploymentKey);
        this.startEventSubscriptionManager.tryReOpenStartEventSubscription(deploymentEvent, this.stateWriter);
    }
}

