/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.model.transformer;

import io.camunda.zeebe.el.Expression;
import io.camunda.zeebe.el.ExpressionLanguage;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableActivity;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableFlowElementContainer;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableLoopCharacteristics;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableMultiInstanceBody;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableProcess;
import io.camunda.zeebe.engine.processing.deployment.model.transformation.ModelElementTransformer;
import io.camunda.zeebe.engine.processing.deployment.model.transformation.TransformContext;
import io.camunda.zeebe.model.bpmn.instance.Activity;
import io.camunda.zeebe.model.bpmn.instance.LoopCharacteristics;
import io.camunda.zeebe.model.bpmn.instance.MultiInstanceLoopCharacteristics;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeLoopCharacteristics;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.Collections;
import java.util.Optional;
import org.agrona.DirectBuffer;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;

public final class MultiInstanceActivityTransformer
implements ModelElementTransformer<Activity> {
    @Override
    public Class<Activity> getType() {
        return Activity.class;
    }

    @Override
    public void transform(Activity element, TransformContext context) {
        ExecutableProcess process = context.getCurrentProcess();
        ExecutableActivity innerActivity = process.getElementById(element.getId(), ExecutableActivity.class);
        LoopCharacteristics loopCharacteristics = element.getLoopCharacteristics();
        if (loopCharacteristics instanceof MultiInstanceLoopCharacteristics) {
            ExecutableLoopCharacteristics miLoopCharacteristics = this.transformLoopCharacteristics(context, (MultiInstanceLoopCharacteristics)loopCharacteristics);
            ExecutableMultiInstanceBody multiInstanceBody = new ExecutableMultiInstanceBody(element.getId(), miLoopCharacteristics, innerActivity);
            multiInstanceBody.setElementType(BpmnElementType.MULTI_INSTANCE_BODY);
            multiInstanceBody.setFlowScope(innerActivity.getFlowScope());
            innerActivity.setFlowScope(multiInstanceBody);
            innerActivity.getBoundaryEvents().forEach(multiInstanceBody::attach);
            innerActivity.getEventSubprocesses().forEach(multiInstanceBody::attach);
            innerActivity.getEvents().removeAll(innerActivity.getBoundaryEvents());
            innerActivity.getEventSubprocesses().stream().map(ExecutableFlowElementContainer::getStartEvents).forEach(innerActivity.getEvents()::remove);
            innerActivity.getInterruptingElementIds().clear();
            innerActivity.getIncoming().forEach(flow -> flow.setTarget(multiInstanceBody));
            innerActivity.getOutgoing().forEach(flow -> flow.setSource(multiInstanceBody));
            multiInstanceBody.getOutgoing().addAll(Collections.unmodifiableList(innerActivity.getOutgoing()));
            innerActivity.getOutgoing().clear();
            process.addFlowElement(multiInstanceBody);
        }
    }

    private ExecutableLoopCharacteristics transformLoopCharacteristics(TransformContext context, MultiInstanceLoopCharacteristics elementLoopCharacteristics) {
        boolean isSequential = elementLoopCharacteristics.isSequential();
        Optional<Expression> completionCondition = Optional.ofNullable(elementLoopCharacteristics.getCompletionCondition()).map(ModelElementInstance::getTextContent).filter(e -> !e.isEmpty()).map(arg_0 -> ((ExpressionLanguage)context.getExpressionLanguage()).parseExpression(arg_0));
        ZeebeLoopCharacteristics zeebeLoopCharacteristics = (ZeebeLoopCharacteristics)elementLoopCharacteristics.getSingleExtensionElement(ZeebeLoopCharacteristics.class);
        Expression inputCollection = context.getExpressionLanguage().parseExpression(zeebeLoopCharacteristics.getInputCollection());
        Optional<DirectBuffer> inputElement = Optional.ofNullable(zeebeLoopCharacteristics.getInputElement()).filter(e -> !e.isEmpty()).map(BufferUtil::wrapString);
        Optional<DirectBuffer> outputCollection = Optional.ofNullable(zeebeLoopCharacteristics.getOutputCollection()).filter(e -> !e.isEmpty()).map(BufferUtil::wrapString);
        Optional<Expression> outputElement = Optional.ofNullable(zeebeLoopCharacteristics.getOutputElement()).filter(e -> !e.isEmpty()).map(e -> context.getExpressionLanguage().parseExpression(e));
        return new ExecutableLoopCharacteristics(isSequential, completionCondition, inputCollection, inputElement, outputCollection, outputElement);
    }
}

