/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.job;

import io.camunda.zeebe.engine.metrics.JobMetrics;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnJobActivationBehavior;
import io.camunda.zeebe.engine.processing.job.DefaultJobCommandPreconditionGuard;
import io.camunda.zeebe.engine.processing.job.JobBackoffChecker;
import io.camunda.zeebe.engine.processing.streamprocessor.CommandProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.SideEffectWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedCommandWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.processing.variable.VariableBehavior;
import io.camunda.zeebe.engine.state.immutable.JobState;
import io.camunda.zeebe.engine.state.immutable.ProcessingState;
import io.camunda.zeebe.protocol.impl.record.value.incident.IncidentRecord;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.value.ErrorType;
import io.camunda.zeebe.stream.api.records.TypedRecord;
import io.camunda.zeebe.stream.api.state.KeyGenerator;
import io.camunda.zeebe.util.StringUtil;
import io.camunda.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;

public final class JobFailProcessor
implements CommandProcessor<JobRecord> {
    private static final DirectBuffer DEFAULT_ERROR_MESSAGE = BufferUtil.wrapString((String)"No more retries left.");
    private static final int MAX_ERROR_MESSAGE_SIZE = 500;
    private final IncidentRecord incidentEvent = new IncidentRecord();
    private final JobState jobState;
    private final DefaultJobCommandPreconditionGuard defaultProcessor;
    private final KeyGenerator keyGenerator;
    private final JobMetrics jobMetrics;
    private final JobBackoffChecker jobBackoffChecker;
    private final VariableBehavior variableBehavior;
    private final BpmnJobActivationBehavior jobActivationBehavior;
    private final SideEffectWriter sideEffectWriter;

    public JobFailProcessor(ProcessingState state, Writers writers, KeyGenerator keyGenerator, JobMetrics jobMetrics, JobBackoffChecker jobBackoffChecker, BpmnBehaviors bpmnBehaviors) {
        this.jobState = state.getJobState();
        this.keyGenerator = keyGenerator;
        this.jobBackoffChecker = jobBackoffChecker;
        this.defaultProcessor = new DefaultJobCommandPreconditionGuard("fail", this.jobState, this::acceptCommand);
        this.jobMetrics = jobMetrics;
        this.variableBehavior = bpmnBehaviors.variableBehavior();
        this.jobActivationBehavior = bpmnBehaviors.jobActivationBehavior();
        this.sideEffectWriter = writers.sideEffect();
    }

    @Override
    public boolean onCommand(TypedRecord<JobRecord> command, CommandProcessor.CommandControl<JobRecord> commandControl) {
        return this.defaultProcessor.onCommand(command, commandControl);
    }

    @Override
    public void afterAccept(TypedCommandWriter commandWriter, StateWriter stateWriter, long key, Intent intent, JobRecord value) {
        DirectBuffer variables = value.getVariablesBuffer();
        if (variables.capacity() > 0) {
            this.variableBehavior.mergeLocalDocument(value.getElementInstanceKey(), value.getProcessDefinitionKey(), value.getProcessInstanceKey(), value.getBpmnProcessIdBuffer(), variables);
        }
        if (value.getRetries() <= 0) {
            DirectBuffer jobErrorMessage = value.getErrorMessageBuffer();
            DirectBuffer incidentErrorMessage = DEFAULT_ERROR_MESSAGE;
            if (jobErrorMessage.capacity() > 0) {
                incidentErrorMessage = jobErrorMessage;
            }
            this.incidentEvent.reset();
            this.incidentEvent.setErrorType(ErrorType.JOB_NO_RETRIES).setErrorMessage(incidentErrorMessage).setBpmnProcessId(value.getBpmnProcessIdBuffer()).setProcessDefinitionKey(value.getProcessDefinitionKey()).setProcessInstanceKey(value.getProcessInstanceKey()).setElementId(value.getElementIdBuffer()).setElementInstanceKey(value.getElementInstanceKey()).setJobKey(key).setVariableScopeKey(value.getElementInstanceKey());
            stateWriter.appendFollowUpEvent(this.keyGenerator.nextKey(), (Intent)IncidentIntent.CREATED, (RecordValue)this.incidentEvent);
        }
    }

    private void acceptCommand(TypedRecord<JobRecord> command, CommandProcessor.CommandControl<JobRecord> commandControl) {
        boolean retryImmediately;
        long key = command.getKey();
        JobRecord failedJob = this.jobState.getJob(key);
        int retries = ((JobRecord)command.getValue()).getRetries();
        long retryBackOff = ((JobRecord)command.getValue()).getRetryBackoff();
        failedJob.setRetries(retries);
        failedJob.setErrorMessage(StringUtil.limitString((String)((JobRecord)command.getValue()).getErrorMessage(), (int)500));
        failedJob.setRetryBackoff(retryBackOff);
        failedJob.setVariables(((JobRecord)command.getValue()).getVariablesBuffer());
        if (retries > 0 && retryBackOff > 0L) {
            long receivedTime = command.getTimestamp();
            failedJob.setRecurringTime(receivedTime + retryBackOff);
            this.sideEffectWriter.appendSideEffect(() -> {
                this.jobBackoffChecker.scheduleBackOff(retryBackOff + receivedTime);
                return true;
            });
        }
        commandControl.accept((Intent)JobIntent.FAILED, failedJob);
        this.jobMetrics.jobFailed(failedJob.getType());
        boolean bl = retryImmediately = retries > 0 && retryBackOff <= 0L;
        if (retryImmediately) {
            this.jobActivationBehavior.publishWork(failedJob);
        }
    }
}

