/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.job;

import io.camunda.zeebe.engine.metrics.JobMetrics;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnJobActivationBehavior;
import io.camunda.zeebe.engine.processing.streamprocessor.CommandProcessor;
import io.camunda.zeebe.engine.state.immutable.JobState;
import io.camunda.zeebe.engine.state.immutable.ProcessingState;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.stream.api.records.TypedRecord;

public final class JobTimeOutProcessor
implements CommandProcessor<JobRecord> {
    public static final String NOT_ACTIVATED_JOB_MESSAGE = "Expected to time out activated job with key '%d', but %s";
    private final JobState jobState;
    private final JobMetrics jobMetrics;
    private final BpmnJobActivationBehavior jobActivationBehavior;

    public JobTimeOutProcessor(ProcessingState state, JobMetrics jobMetrics, BpmnJobActivationBehavior jobActivationBehavior) {
        this.jobState = state.getJobState();
        this.jobMetrics = jobMetrics;
        this.jobActivationBehavior = jobActivationBehavior;
    }

    @Override
    public boolean onCommand(TypedRecord<JobRecord> command, CommandProcessor.CommandControl<JobRecord> commandControl) {
        long jobKey = command.getKey();
        JobState.State state = this.jobState.getState(jobKey);
        if (state == JobState.State.ACTIVATED) {
            JobRecord timedOutJob = (JobRecord)command.getValue();
            commandControl.accept((Intent)JobIntent.TIMED_OUT, timedOutJob);
            this.jobMetrics.jobTimedOut(timedOutJob.getType());
            this.jobActivationBehavior.publishWork(timedOutJob);
        } else {
            commandControl.reject(RejectionType.NOT_FOUND, String.format(NOT_ACTIVATED_JOB_MESSAGE, jobKey, switch (state) {
                case JobState.State.ACTIVATABLE -> "it must be activated first";
                case JobState.State.FAILED -> "it is marked as failed";
                default -> "no such job was found";
            }));
        }
        return true;
    }
}

