/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.appliers;

import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCallActivity;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableEndEvent;
import io.camunda.zeebe.engine.state.TypedEventApplier;
import io.camunda.zeebe.engine.state.appliers.BufferedStartMessageEventStateApplier;
import io.camunda.zeebe.engine.state.immutable.ProcessState;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.engine.state.mutable.MutableElementInstanceState;
import io.camunda.zeebe.engine.state.mutable.MutableEventScopeInstanceState;
import io.camunda.zeebe.engine.state.mutable.MutableVariableState;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import org.agrona.DirectBuffer;

final class ProcessInstanceElementCompletedApplier
implements TypedEventApplier<ProcessInstanceIntent, ProcessInstanceRecord> {
    private final MutableElementInstanceState elementInstanceState;
    private final MutableEventScopeInstanceState eventScopeInstanceState;
    private final MutableVariableState variableState;
    private final ProcessState processState;
    private final BufferedStartMessageEventStateApplier bufferedStartMessageEventStateApplier;

    public ProcessInstanceElementCompletedApplier(MutableElementInstanceState elementInstanceState, MutableEventScopeInstanceState eventScopeInstanceState, MutableVariableState variableState, ProcessState processState, BufferedStartMessageEventStateApplier bufferedStartMessageEventStateApplier) {
        this.elementInstanceState = elementInstanceState;
        this.eventScopeInstanceState = eventScopeInstanceState;
        this.variableState = variableState;
        this.processState = processState;
        this.bufferedStartMessageEventStateApplier = bufferedStartMessageEventStateApplier;
    }

    @Override
    public void applyState(long key, ProcessInstanceRecord value) {
        long parentElementInstanceKey = value.getParentElementInstanceKey();
        if (this.isChildProcess(value, parentElementInstanceKey)) {
            this.propagateVariables(key, parentElementInstanceKey);
        }
        this.bufferedStartMessageEventStateApplier.removeMessageLock(value);
        this.eventScopeInstanceState.deleteInstance(key);
        this.elementInstanceState.removeInstance(key);
        ElementInstance flowScopeInstance = this.elementInstanceState.getInstance(value.getFlowScopeKey());
        if (flowScopeInstance == null) {
            return;
        }
        BpmnElementType flowScopeElementType = flowScopeInstance.getValue().getBpmnElementType();
        this.manageMultiInstance(flowScopeInstance, flowScopeElementType);
        if (this.isTerminateEndEvent(value)) {
            flowScopeInstance.resetActiveSequenceFlows();
            flowScopeInstance.setInterruptingElementId(value.getElementIdBuffer());
            this.elementInstanceState.updateInstance(flowScopeInstance);
        }
    }

    private boolean isChildProcess(ProcessInstanceRecord value, long parentElementInstanceKey) {
        return parentElementInstanceKey > 0L && value.getBpmnElementType() == BpmnElementType.PROCESS;
    }

    private void propagateVariables(long key, long parentElementInstanceKey) {
        ElementInstance parentElementInstance = this.elementInstanceState.getInstance(parentElementInstanceKey);
        DirectBuffer elementId = parentElementInstance.getValue().getElementIdBuffer();
        ExecutableCallActivity callActivity = this.processState.getFlowElement(parentElementInstance.getValue().getProcessDefinitionKey(), elementId, ExecutableCallActivity.class);
        if (callActivity.getOutputMappings().isPresent() || callActivity.isPropagateAllChildVariablesEnabled()) {
            DirectBuffer variables = this.variableState.getVariablesAsDocument(key);
            this.eventScopeInstanceState.triggerEvent(parentElementInstanceKey, parentElementInstanceKey, elementId, variables, parentElementInstance.getValue().getProcessInstanceKey());
        }
    }

    private void manageMultiInstance(ElementInstance flowScopeInstance, BpmnElementType flowScopeElementType) {
        if (flowScopeElementType == BpmnElementType.MULTI_INSTANCE_BODY) {
            flowScopeInstance.incrementNumberOfCompletedElementInstances();
            this.elementInstanceState.updateInstance(flowScopeInstance);
        }
    }

    private boolean isTerminateEndEvent(ProcessInstanceRecord value) {
        if (value.getBpmnElementType().equals((Object)BpmnElementType.END_EVENT)) {
            ExecutableEndEvent element = this.processState.getFlowElement(value.getProcessDefinitionKey(), value.getElementIdBuffer(), ExecutableEndEvent.class);
            return element.isTerminateEndEvent();
        }
        return false;
    }
}

