/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.deployment;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.engine.state.deployment.NextValue;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import org.agrona.DirectBuffer;
import org.agrona.collections.Object2LongHashMap;

public final class ProcessVersionManager {
    private final long initialValue;
    private final ColumnFamily<DbString, NextValue> nextValueColumnFamily;
    private final DbString processIdKey;
    private final NextValue nextVersion = new NextValue();
    private final Object2LongHashMap<String> versionCache;

    public ProcessVersionManager(long initialValue, ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        this.initialValue = initialValue;
        this.processIdKey = new DbString();
        this.nextValueColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.PROCESS_VERSION, transactionContext, (DbKey)this.processIdKey, (DbValue)this.nextVersion);
        this.versionCache = new Object2LongHashMap(initialValue);
    }

    public void setProcessVersion(String processId, long value) {
        this.processIdKey.wrapString(processId);
        this.nextVersion.set(value);
        this.nextValueColumnFamily.upsert((DbKey)this.processIdKey, (DbValue)this.nextVersion);
        this.versionCache.put((Object)processId, value);
    }

    public long getCurrentProcessVersion(String processId) {
        this.processIdKey.wrapString(processId);
        return this.getCurrentProcessVersion();
    }

    public long getCurrentProcessVersion(DirectBuffer processId) {
        this.processIdKey.wrapBuffer(processId);
        return this.getCurrentProcessVersion();
    }

    private long getCurrentProcessVersion() {
        return this.versionCache.computeIfAbsent((Object)this.processIdKey.toString(), key -> this.getProcessVersionFromDB());
    }

    private long getProcessVersionFromDB() {
        NextValue readValue = (NextValue)this.nextValueColumnFamily.get((DbKey)this.processIdKey);
        long currentValue = this.initialValue;
        if (readValue != null) {
            currentValue = readValue.get();
        }
        return currentValue;
    }
}

