/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.instance;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbCompositeKey;
import io.camunda.zeebe.db.impl.DbForeignKey;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbNil;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.engine.Loggers;
import io.camunda.zeebe.engine.state.immutable.JobState;
import io.camunda.zeebe.engine.state.instance.JobRecordValue;
import io.camunda.zeebe.engine.state.instance.JobStateValue;
import io.camunda.zeebe.engine.state.mutable.MutableJobState;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.util.EnsureUtil;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import org.agrona.DirectBuffer;
import org.slf4j.Logger;

public final class DbJobState
implements JobState,
MutableJobState {
    private static final Logger LOG = Loggers.PROCESS_PROCESSOR_LOGGER;
    private final JobRecordValue jobRecordToRead = new JobRecordValue();
    private final JobRecordValue jobRecordToWrite = new JobRecordValue();
    private final DbLong jobKey;
    private final DbForeignKey<DbLong> fkJob;
    private final ColumnFamily<DbLong, JobRecordValue> jobsColumnFamily;
    private final JobStateValue jobState = new JobStateValue();
    private final ColumnFamily<DbForeignKey<DbLong>, JobStateValue> statesJobColumnFamily;
    private final DbString jobTypeKey;
    private final DbCompositeKey<DbString, DbForeignKey<DbLong>> typeJobKey;
    private final ColumnFamily<DbCompositeKey<DbString, DbForeignKey<DbLong>>, DbNil> activatableColumnFamily;
    private final DbLong deadlineKey;
    private final DbCompositeKey<DbLong, DbForeignKey<DbLong>> deadlineJobKey;
    private final ColumnFamily<DbCompositeKey<DbLong, DbForeignKey<DbLong>>, DbNil> deadlinesColumnFamily;
    private final DbLong backoffKey;
    private final DbCompositeKey<DbLong, DbForeignKey<DbLong>> backoffJobKey;
    private final ColumnFamily<DbCompositeKey<DbLong, DbForeignKey<DbLong>>, DbNil> backoffColumnFamily;
    private long nextBackOffDueDate;

    public DbJobState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext, int partitionId) {
        this.jobKey = new DbLong();
        this.fkJob = new DbForeignKey((DbKey)this.jobKey, (Enum)ZbColumnFamilies.JOBS);
        this.jobsColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.JOBS, transactionContext, (DbKey)this.jobKey, (DbValue)this.jobRecordToRead);
        this.statesJobColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.JOB_STATES, transactionContext, this.fkJob, (DbValue)this.jobState);
        this.jobTypeKey = new DbString();
        this.typeJobKey = new DbCompositeKey((DbKey)this.jobTypeKey, this.fkJob);
        this.activatableColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.JOB_ACTIVATABLE, transactionContext, this.typeJobKey, (DbValue)DbNil.INSTANCE);
        this.deadlineKey = new DbLong();
        this.deadlineJobKey = new DbCompositeKey((DbKey)this.deadlineKey, this.fkJob);
        this.deadlinesColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.JOB_DEADLINES, transactionContext, this.deadlineJobKey, (DbValue)DbNil.INSTANCE);
        this.backoffKey = new DbLong();
        this.backoffJobKey = new DbCompositeKey((DbKey)this.backoffKey, this.fkJob);
        this.backoffColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.JOB_BACKOFF, transactionContext, this.backoffJobKey, (DbValue)DbNil.INSTANCE);
    }

    @Override
    public void create(long key, JobRecord record) {
        DirectBuffer type = record.getTypeBuffer();
        this.createJob(key, record, type);
    }

    @Override
    public void activate(long key, JobRecord record) {
        DirectBuffer type = record.getTypeBuffer();
        long deadline = record.getDeadline();
        this.validateParameters(type);
        EnsureUtil.ensureGreaterThan((String)"deadline", (long)deadline, (long)0L);
        this.updateJobRecord(key, record);
        this.updateJobState(JobState.State.ACTIVATED);
        this.makeJobNotActivatable(type);
        this.deadlineKey.wrapLong(deadline);
        this.deadlinesColumnFamily.insert(this.deadlineJobKey, (DbValue)DbNil.INSTANCE);
    }

    @Override
    public void recurAfterBackoff(long key, JobRecord record) {
        this.updateJob(key, record, JobState.State.ACTIVATABLE);
        this.jobKey.wrapLong(key);
        this.backoffKey.wrapLong(record.getRecurringTime());
        this.backoffColumnFamily.deleteExisting(this.backoffJobKey);
    }

    @Override
    public void timeout(long key, JobRecord record) {
        DirectBuffer type = record.getTypeBuffer();
        long deadline = record.getDeadline();
        this.validateParameters(type);
        EnsureUtil.ensureGreaterThan((String)"deadline", (long)deadline, (long)0L);
        this.updateJob(key, record, JobState.State.ACTIVATABLE);
        this.removeJobDeadline(deadline);
    }

    @Override
    public void complete(long key, JobRecord record) {
        this.delete(key, record);
    }

    @Override
    public void cancel(long key, JobRecord record) {
        this.delete(key, record);
    }

    @Override
    public void disable(long key, JobRecord record) {
        this.updateJob(key, record, JobState.State.FAILED);
        this.makeJobNotActivatable(record.getTypeBuffer());
    }

    @Override
    public void throwError(long key, JobRecord updatedValue) {
        this.updateJob(key, updatedValue, JobState.State.ERROR_THROWN);
        this.makeJobNotActivatable(updatedValue.getTypeBuffer());
    }

    @Override
    public void delete(long key, JobRecord record) {
        DirectBuffer type = record.getTypeBuffer();
        long deadline = record.getDeadline();
        this.jobKey.wrapLong(key);
        this.jobsColumnFamily.deleteExisting((DbKey)this.jobKey);
        this.statesJobColumnFamily.deleteExisting(this.fkJob);
        this.makeJobNotActivatable(type);
        this.removeJobDeadline(deadline);
    }

    @Override
    public void fail(long key, JobRecord updatedValue) {
        if (updatedValue.getRetries() > 0) {
            if (updatedValue.getRetryBackoff() > 0L) {
                this.jobKey.wrapLong(key);
                this.backoffKey.wrapLong(updatedValue.getRecurringTime());
                this.backoffColumnFamily.insert(this.backoffJobKey, (DbValue)DbNil.INSTANCE);
                this.updateJob(key, updatedValue, JobState.State.FAILED);
            } else {
                this.updateJob(key, updatedValue, JobState.State.ACTIVATABLE);
            }
        } else {
            this.updateJob(key, updatedValue, JobState.State.FAILED);
            this.makeJobNotActivatable(updatedValue.getTypeBuffer());
        }
    }

    @Override
    public void resolve(long key, JobRecord updatedValue) {
        this.updateJob(key, updatedValue, JobState.State.ACTIVATABLE);
    }

    @Override
    public JobRecord updateJobRetries(long jobKey, int retries) {
        JobRecord job = this.getJob(jobKey);
        if (job != null) {
            job.setRetries(retries);
            this.updateJobRecord(jobKey, job);
        }
        return job;
    }

    private void createJob(long key, JobRecord record, DirectBuffer type) {
        this.createJobRecord(key, record);
        this.initializeJobState();
        this.makeJobActivatable(type, key);
    }

    private void updateJob(long key, JobRecord updatedValue, JobState.State newState) {
        DirectBuffer type = updatedValue.getTypeBuffer();
        long deadline = updatedValue.getDeadline();
        this.validateParameters(type);
        this.updateJobRecord(key, updatedValue);
        this.updateJobState(newState);
        if (newState == JobState.State.ACTIVATABLE) {
            this.makeJobActivatable(type, key);
        }
        if (deadline > 0L) {
            this.removeJobDeadline(deadline);
        }
    }

    private void validateParameters(DirectBuffer type) {
        EnsureUtil.ensureNotNullOrEmpty((String)"type", (DirectBuffer)type);
    }

    @Override
    public void forEachTimedOutEntry(long upperBound, BiFunction<Long, JobRecord, Boolean> callback) {
        this.deadlinesColumnFamily.whileTrue((key, value) -> {
            boolean isDue;
            long deadline = ((DbLong)key.first()).getValue();
            boolean bl = isDue = deadline < upperBound;
            if (isDue) {
                long jobKey1 = ((DbLong)((DbForeignKey)key.second()).inner()).getValue();
                return this.visitJob(jobKey1, callback::apply, () -> this.deadlinesColumnFamily.deleteExisting(key));
            }
            return false;
        });
    }

    @Override
    public boolean exists(long jobKey) {
        this.jobKey.wrapLong(jobKey);
        return this.jobsColumnFamily.exists((DbKey)this.jobKey);
    }

    @Override
    public JobState.State getState(long key) {
        this.jobKey.wrapLong(key);
        JobStateValue storedState = (JobStateValue)this.statesJobColumnFamily.get(this.fkJob);
        if (storedState == null) {
            return JobState.State.NOT_FOUND;
        }
        return storedState.getState();
    }

    @Override
    public boolean isInState(long key, JobState.State state) {
        return this.getState(key) == state;
    }

    @Override
    public void forEachActivatableJobs(DirectBuffer type, BiFunction<Long, JobRecord, Boolean> callback) {
        this.jobTypeKey.wrapBuffer(type);
        this.activatableColumnFamily.whileEqualPrefix((DbKey)this.jobTypeKey, (compositeKey, zbNil) -> {
            long jobKey = ((DbLong)((DbForeignKey)compositeKey.second()).inner()).getValue();
            return this.visitJob(jobKey, callback::apply, () -> {});
        });
    }

    @Override
    public JobRecord getJob(long key) {
        this.jobKey.wrapLong(key);
        JobRecordValue jobState = (JobRecordValue)this.jobsColumnFamily.get((DbKey)this.jobKey);
        return jobState == null ? null : jobState.getRecord();
    }

    @Override
    public long findBackedOffJobs(long timestamp, BiPredicate<Long, JobRecord> callback) {
        this.nextBackOffDueDate = -1L;
        this.backoffColumnFamily.whileTrue((key, value) -> {
            long deadline = ((DbLong)key.first()).getValue();
            boolean consumed = false;
            if (deadline <= timestamp) {
                long jobKey = ((DbLong)((DbForeignKey)key.second()).inner()).getValue();
                consumed = this.visitJob(jobKey, callback, () -> this.backoffColumnFamily.deleteExisting(key));
            }
            if (!consumed) {
                this.nextBackOffDueDate = deadline;
            }
            return consumed;
        });
        return this.nextBackOffDueDate;
    }

    boolean visitJob(long jobKey, BiPredicate<Long, JobRecord> callback, Runnable cleanupRunnable) {
        JobRecord job = this.getJob(jobKey);
        if (job == null) {
            LOG.error("Expected to find job with key {}, but no job found", (Object)jobKey);
            cleanupRunnable.run();
            return true;
        }
        return callback.test(jobKey, job);
    }

    private void createJobRecord(long key, JobRecord record) {
        this.jobKey.wrapLong(key);
        this.jobRecordToWrite.setRecordWithoutVariables(record);
        this.jobsColumnFamily.insert((DbKey)this.jobKey, (DbValue)this.jobRecordToWrite);
    }

    private void updateJobRecord(long key, JobRecord updatedValue) {
        this.jobKey.wrapLong(key);
        this.jobRecordToWrite.setRecordWithoutVariables(updatedValue);
        this.jobsColumnFamily.update((DbKey)this.jobKey, (DbValue)this.jobRecordToWrite);
    }

    private void initializeJobState() {
        this.jobState.setState(JobState.State.ACTIVATABLE);
        this.statesJobColumnFamily.insert(this.fkJob, (DbValue)this.jobState);
    }

    private void updateJobState(JobState.State newState) {
        this.jobState.setState(newState);
        this.statesJobColumnFamily.update(this.fkJob, (DbValue)this.jobState);
    }

    private void makeJobActivatable(DirectBuffer type, long key) {
        EnsureUtil.ensureNotNullOrEmpty((String)"type", (DirectBuffer)type);
        this.jobTypeKey.wrapBuffer(type);
        this.jobKey.wrapLong(key);
        this.activatableColumnFamily.upsert(this.typeJobKey, (DbValue)DbNil.INSTANCE);
    }

    private void makeJobNotActivatable(DirectBuffer type) {
        EnsureUtil.ensureNotNullOrEmpty((String)"type", (DirectBuffer)type);
        this.jobTypeKey.wrapBuffer(type);
        this.activatableColumnFamily.deleteIfExists(this.typeJobKey);
    }

    private void removeJobDeadline(long deadline) {
        this.deadlineKey.wrapLong(deadline);
        this.deadlinesColumnFamily.deleteIfExists(this.deadlineJobKey);
    }
}

