/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.identity.sdk.authentication;

import com.auth0.jwt.interfaces.DecodedJWT;
import io.camunda.identity.sdk.authentication.UserDetails;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.Validate;

public class AccessToken
implements Serializable {
    private static final long serialVersionUID = -1646956221165712612L;
    private final DecodedJWT token;
    private final List<String> permissions;
    private final UserDetails userDetails;

    AccessToken(DecodedJWT token, List<String> permissions, UserDetails userDetails) {
        Validate.notNull((Object)token, (String)"token must not be null", (Object[])new Object[0]);
        Validate.notNull(permissions, (String)"permissions must not be null", (Object[])new Object[0]);
        this.token = token;
        this.permissions = permissions;
        this.userDetails = userDetails;
    }

    public DecodedJWT getToken() {
        return this.token;
    }

    public boolean hasPermissions(Set<String> permissions) {
        return this.permissions.containsAll(permissions);
    }

    public List<String> getPermissions() {
        return this.permissions;
    }

    public UserDetails getUserDetails() {
        return this.userDetails;
    }
}

