/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.stream.impl.records;

import io.camunda.zeebe.logstreams.log.LogAppendEntry;
import io.camunda.zeebe.protocol.impl.record.RecordMetadata;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.stream.impl.TypedEventRegistry;
import io.camunda.zeebe.util.ReflectUtil;
import io.camunda.zeebe.util.buffer.BufferWriter;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public record RecordBatchEntry(RecordMetadata recordMetadata, long key, int sourceIndex, UnifiedRecordValue unifiedRecordValue) implements LogAppendEntry
{
    public UnifiedRecordValue recordValue() {
        return this.unifiedRecordValue;
    }

    public static RecordBatchEntry createEntry(long key, int sourceIndex, RecordType recordType, Intent intent, RejectionType rejectionType, String rejectionReason, ValueType valueType, BufferWriter valueWriter) {
        RecordMetadata recordMetadata = new RecordMetadata().recordType(recordType).intent(intent).rejectionType(rejectionType).rejectionReason(rejectionReason).valueType(valueType);
        byte[] bytes = new byte[valueWriter.getLength()];
        UnsafeBuffer recordValueBuffer = new UnsafeBuffer(bytes);
        valueWriter.write((MutableDirectBuffer)recordValueBuffer, 0);
        UnifiedRecordValue unifiedRecordValue = (UnifiedRecordValue)ReflectUtil.newInstance(TypedEventRegistry.EVENT_REGISTRY.get(recordMetadata.getValueType()));
        unifiedRecordValue.wrap((DirectBuffer)recordValueBuffer, 0, recordValueBuffer.capacity());
        return new RecordBatchEntry(recordMetadata, key, sourceIndex, unifiedRecordValue);
    }
}

